package com.yd.base.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.base.feign.request.relobjectcategory.ApiRelObjectCategoryQueryRequest;
import com.yd.base.feign.response.relobjectcategory.ApiRelObjectCategoryQueryResponse;
import com.yd.base.service.dao.RelObjectCategoryMapper;
import com.yd.base.service.model.RelObjectCategory;
import com.yd.base.service.service.IRelObjectCategoryService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 对象分类关系表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-11-20
 */
@Service
public class RelObjectCategoryServiceImpl extends ServiceImpl<RelObjectCategoryMapper, RelObjectCategory> implements IRelObjectCategoryService {

    @Override
    public List<ApiRelObjectCategoryQueryResponse> query(ApiRelObjectCategoryQueryRequest request) {
        return baseMapper.query(request);
    }

    @Override
    public Boolean delByObjectBizId(String objectBizId) {
        return this.remove(new LambdaQueryWrapper<RelObjectCategory>().eq(RelObjectCategory::getObjectBizId,objectBizId));
    }

    @Override
    public Boolean delByCategoryBizId(String categoryBizId) {
        return this.remove(new LambdaQueryWrapper<RelObjectCategory>().eq(RelObjectCategory::getCategoryBizId,categoryBizId));
    }
}
