package com.yd.base.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.base.api.service.ApiBankService;
import com.yd.base.feign.client.bank.ApiBankFeignClient;
import com.yd.base.feign.request.bank.ApiBankAddRequest;
import com.yd.base.feign.request.bank.ApiBankEditRequest;
import com.yd.base.feign.request.bank.ApiBankListRequest;
import com.yd.base.feign.request.bank.ApiBankPageRequest;
import com.yd.base.feign.response.bank.ApiBankDetailResponse;
import com.yd.base.feign.response.bank.ApiBankPageResponse;
import com.yd.common.result.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import java.util.List;

/**
 * 银行基础信息
 *
 * @author zxm
 * @since 2025-12-22
 */
@RestController
@RequestMapping("/bank")
@Validated
public class ApiBankController implements ApiBankFeignClient {

    @Autowired
    private ApiBankService apiBankService;

    /**
     * 分页列表查询-银行信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiBankPageResponse>> page(ApiBankPageRequest request) {
        return apiBankService.page(request);
    }

    /**
     * 列表查询-银行信息
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiBankDetailResponse>> list(ApiBankListRequest request) {
        return apiBankService.list(request);
    }

    /**
     * 添加-银行信息
     * @param request
     * @return
     */
    @Override
    public Result add(ApiBankAddRequest request) {
        return apiBankService.add(request);
    }

    /**
     * 编辑-银行信息
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiBankEditRequest request) {
        return apiBankService.edit(request);
    }

    /**
     * 详情-银行信息
     * @param bankBizId 银行信息表唯一业务ID
     * @return
     */
    @Override
    public Result<ApiBankDetailResponse> detail(String bankBizId) {
        return apiBankService.detail(bankBizId);
    }

    /**
     * 删除-银行信息
     * @param bankBizId 银行信息表唯一业务ID
     * @return
     */
    @Override
    public Result del(String bankBizId) {
        return apiBankService.del(bankBizId);
    }

    /**
     * 编辑银行信息状态
     * @param bankBizId 银行信息唯一标识(业务ID)
     * @param status 状态：1-有效，0-无效。
     * @return
     */
    @Override
    public Result editStatus(String bankBizId, Integer status) {
        return apiBankService.editStatus(bankBizId,status);
    }
}
