package com.yd.base.api.controller;

import com.yd.base.api.service.ApiExchangeRateService;
import com.yd.base.feign.client.exchangerate.ApiExchangeRateFeignClient;
import com.yd.base.feign.request.exchangerate.ApiExchangeRateConvertRequest;
import com.yd.base.feign.response.exchangerate.ApiExchangeRateConvertResponse;
import com.yd.common.result.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import java.math.BigDecimal;
import java.util.List;

/**
 * 汇率信息
 *
 * @author zxm
 * @since 2025-12-29
 */
@RestController
@RequestMapping("/exchangeRate")
@Validated
public class ApiExchangeRateController implements ApiExchangeRateFeignClient {

    @Autowired
    private ApiExchangeRateService apiExchangeRateService;

    /**
     * 货币转换
     * @param request
     * @return
     */
    @Override
    public Result<ApiExchangeRateConvertResponse> convert(ApiExchangeRateConvertRequest request) {
        return apiExchangeRateService.convert(request);
    }

    /**
     * 获取汇率
     * @param baseCurrency 基础币种
     * @param targetCurrency 目标币种
     * @param date
     * @return
     */
    @Override
    public Result<BigDecimal> getExchangeRate(String baseCurrency, String targetCurrency, String date) {
        return apiExchangeRateService.getExchangeRate(baseCurrency,targetCurrency,date);
    }

    /**
     * 批量转换
     * @param requests
     * @return
     */
    @Override
    public Result<List<ApiExchangeRateConvertResponse>> batchConvert(List<ApiExchangeRateConvertRequest> requests) {
        return apiExchangeRateService.batchConvert(requests);
    }

    /**
     * 验证币种是否支持
     * @param currency
     * @return
     */
    @Override
    public Result<Boolean> isCurrencySupportedResult(String currency) {
        return apiExchangeRateService.isCurrencySupportedResult(currency);
    }

    /**
     * 获取支持的币种列表
     * @return
     */
    @Override
    public Result<List<String>> getSupportedCurrencies() {
        return apiExchangeRateService.getSupportedCurrencies();
    }
}
