package com.yd.base.api.service;

import com.yd.base.feign.request.exchangerate.ApiExchangeRateConvertRequest;
import com.yd.base.feign.response.exchangerate.ApiExchangeRateConvertResponse;
import com.yd.common.result.Result;

import java.math.BigDecimal;
import java.util.List;

public interface ApiExchangeRateService {

    Result<List<String>> getSupportedCurrencies();

    Result<ApiExchangeRateConvertResponse> convert(ApiExchangeRateConvertRequest request);

    Result<BigDecimal> getExchangeRate(String baseCurrency, String targetCurrency, String date);

    Result<List<ApiExchangeRateConvertResponse>> batchConvert(List<ApiExchangeRateConvertRequest> requests);

    Result<Boolean> isCurrencySupportedResult(String currency);
}
