package com.yd.base.feign.fallback.relobjectcategory;

import com.yd.base.feign.client.relobjectcategory.ApiRelObjectCategoryFeignClient;
import com.yd.base.feign.request.relobjectcategory.ApiRelCategoryObjectListAddRequest;
import com.yd.base.feign.request.relobjectcategory.ApiRelObjectCategoryListAddRequest;
import com.yd.base.feign.request.relobjectcategory.ApiRelObjectCategoryQueryRequest;
import com.yd.base.feign.request.relobjectcategory.ApiRelObjectCategoryQuerySelectedRequest;
import com.yd.base.feign.response.relobjectcategory.ApiRelObjectCategoryQueryResponse;
import com.yd.base.feign.response.relobjectcategory.ApiRelObjectCategoryQuerySelectedResponse;
import com.yd.common.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 基础数据服务-对象分类关系信息Feign降级处理
 */
@Slf4j
@Component
public class ApiRelObjectCategoryFeignFallbackFactory implements FallbackFactory<ApiRelObjectCategoryFeignClient> {
    @Override
    public ApiRelObjectCategoryFeignClient create(Throwable cause) {
        return new ApiRelObjectCategoryFeignClient() {

            @Override
            public Result<List<ApiRelObjectCategoryQueryResponse>> query(ApiRelObjectCategoryQueryRequest request) {
                return null;
            }

            @Override
            public Result<List<ApiRelObjectCategoryQuerySelectedResponse>> querySelected(ApiRelObjectCategoryQuerySelectedRequest request) {
                return null;
            }

            @Override
            public Result addRelObjectCategoryList(ApiRelObjectCategoryListAddRequest request) {
                return null;
            }

            @Override
            public Result addRelCategoryObjectList(ApiRelCategoryObjectListAddRequest request) {
                return null;
            }
        };
    }
}
