package com.yd.base.service.utils;

import com.baomidou.mybatisplus.generator.FastAutoGenerator;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;

public class MyBatisPlusCodeGenerator {
    public static void main(String[] args) {
        FastAutoGenerator.create("jdbc:mysql://localhost:3306/yd_product?serverTimezone=GMT%2B8", "root", "123456")
                .globalConfig(builder -> {
                    builder.author("zxm")
//                            .outputDir("src/main/java/com/yd/user/service");
                            .outputDir("D:/soft/ideaproject/v2/yd-base/yd-base-service/src/main/java");
                })
                .packageConfig(builder -> {
                    builder.parent("com.yd.base.service")
                            .entity("model")
                            .mapper("dao")
                            .service("service")
                            .serviceImpl("service.impl")
                            .xml("mappers");
                })
                .strategyConfig(builder -> {
                    builder.addInclude(
                            "species_type"
                    )
                            .entityBuilder()
                            .enableLombok()
                            .enableTableFieldAnnotation()
                            .controllerBuilder()
                            .enableRestStyle();
                })
                .templateEngine(new FreemarkerTemplateEngine())
                .execute();
    }
}

