package com.yd.common.enums;

/**
 * 公共枚举
 */
public enum CommonEnum {

    //业务唯一标识id的类型枚举
    UID_TYPE_TENANT("tenant","租户"),
    UID_TYPE_PROJECT("project","项目"),
    UID_TYPE_USER("user","用户"),
    UID_TYPE_ROLE("role","角色"),
    UID_TYPE_MENU("menu","菜单"),
    UID_TYPE_DEPT("dept","部门"),
    UID_TYPE_INSURANCE_PRODUCT("insurance_product","保险产品"),
    UID_TYPE_INSURANCE_PRODUCT_PLAN("insurance_product_plan","保险产品计划"),
    UID_TYPE_INSURANCE_ADDITIONAL_PRODUCT("insurance_additional_product","保险附加产品"),
    UID_TYPE_OSS_FILE("oss_file","OSS文件元数据"),
    UID_TYPE_CUSTOMER("customer","CSF客户表"),
    UID_TYPE_FNA("fna","CSF签单流程表"),
    UID_TYPE_FNA_FORM("fna_form","Fna表单表"),
    UID_TYPE_APPOINTMENT("appointment","预约信息主表"),
    UID_TYPE_PRODUCT_PLAN("product_plan","产品计划信息表"),
    UID_TYPE_ADDITIONAL("additional","产品计划-附加险信息表"),
    UID_TYPE_POLICYHOLDER("policyholder","投保人信息表"),
    UID_TYPE_INSURANT("insurant","受保人信息表"),
    UID_TYPE_BENEFICIARY("beneficiary","受益人信息表"),
    UID_TYPE_SECOND_HOLDER("second_holder","第二持有人信息表"),
    UID_TYPE_APPOINTMENT_FILE("appointment_file","预约附件信息表"),
    UID_TYPE_POLICY("policy","CSF保单表"),
    UID_TYPE_COMMISSION("commission","CSF来佣表"),
    UID_TYPE_FORTUNE("fortune","CSF发佣表"),
    UID_TYPE_EMAIL_SENDER_CONFIG("email_sender_config","邮箱发件人配置表"),
    UID_TYPE_EMAIL_CONTACT("email_contact","邮箱联系人（收件人）表"),
    UID_TYPE_EMAIL_PROVIDER_CONFIG("email_provider_config","SMTP邮箱服务商配置表"),
    UID_TYPE_EMAIL_VARIABLE("email_variable","邮箱变量表"),
    UID_TYPE_EMAIL_VARIABLE_GROUP("email_variable_group","变量分组表"),
    UID_TYPE_EMAIL_CONTACT_IMPORT("email_contact_import","邮件联系人导入临时表"),
    UID_TYPE_EMAIL_TASK("email_task","邮件任务表"),
    UID_TYPE_ANSWER_SESSIONS("answer_sessions","答题会话表"),
    UID_TYPE_COMMISSION_RULE_CONFIG("commission_rule_config","基本法配置表"),
    UID_TYPE_RULE_ITEM_CONFIG("rule_item_config","基本法项目配置表"),
    UID_TYPE_VARIABLE("variable","变量表"),
    UID_TYPE_FORMULA_CONFIG("formula_config","公式配置表"),
    UID_TYPE_CONDITION_CONFIG("condition_config","条件配置表"),
    UID_TYPE_CONDITION_TYPE("condition_type","条件类型表"),
    UID_TYPE_CLIENT_USER("client_user","客户端用户表"),

    //作用域枚举
    SCOPE_SYS("1","系统级（全局）"),
    SCOPE_TENANT("2","租户级"),
    SCOPE_PROJECT("3","项目级"),

    //作用域对应的数据范围枚举
    DATA_SCOPE_PUBLIC("0","公开"),
    DATA_SCOPE_PRIVATE("1","私有"),

    //操作来源枚举
    OPR_SOURCE_ADD("1","添加"),
    OPR_SOURCE_EDIT("2","编辑"),

    //端来源
    PROJECT_TYPE_PC("PC","管理端"),
    PROJECT_TYPE_CLIENT("CLIENT","客户端"),

    //审批状态
    APPROVAL_STATUS_DSH("DSH","待审核"),
    APPROVAL_STATUS_CG("CG","审核成功"),
    APPROVAL_STATUS_SB("SB","审核失败"),


    ;

    //编码
    private String code;
    //名称
    private String name;

    //构造函数
    CommonEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
