//package com.yd.gateway.config;
//
//import com.yd.auth.core.security.JwtTokenProvider;
//import com.yd.auth.core.security.JwtTokenProvider.JwtAuthenticationException;
//import io.jsonwebtoken.Claims;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.context.annotation.Bean;
//import org.springframework.context.annotation.Configuration;
//import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
//import org.springframework.security.config.web.server.ServerHttpSecurity;
//import org.springframework.security.oauth2.jwt.Jwt;
//import org.springframework.security.web.server.SecurityWebFilterChain;
//import reactor.core.publisher.Mono;
//
//@Configuration
//@EnableWebFluxSecurity
//public class GatewaySecurityConfig {
//
//
////    private final JwtTokenProvider jwtTokenProvider;
////
////    public GatewaySecurityConfig(JwtTokenProvider jwtTokenProvider) {
////        this.jwtTokenProvider = jwtTokenProvider;
////    }
//
//    @Autowired
//    private JwtTokenProvider jwtTokenProvider;
//
//    @Bean
//    public SecurityWebFilterChain securityWebFilterChain(ServerHttpSecurity http) {
//        http
//                .csrf().disable()
//                .authorizeExchange(exchanges -> exchanges
//                        .pathMatchers(
//                                "/auth/**",
//                                "/swagger-ui/**",
//                                "/v3/api-docs/**"
//                        ).permitAll() // 放行认证和Swagger路径
//                        .anyExchange().authenticated() // 其他请求需要认证
//                )
//                .oauth2ResourceServer(oauth2 -> oauth2
//                        .jwt(jwt -> jwt
//                                .jwtDecoder(token -> {
//                                    try {
//                                        // 验证令牌有效性
//                                        jwtTokenProvider.validateToken(token);
//
//                                        // 完整解析 JWT 令牌
//                                        Claims claims = jwtTokenProvider.parseClaims(token);
//
//                                        // 构建完整 JWT 对象
//                                        return Mono.just(new Jwt(
//                                                token,
//                                                claims.getIssuedAt().toInstant(),
//                                                claims.getExpiration().toInstant(),
//                                                jwtTokenProvider.getHeaders(token), // 获取头部信息
//                                                claims
//                                        ));
//                                    } catch (JwtAuthenticationException e) {
//                                        return Mono.error(e);
//                                    }
//                                })
//                        )
//                );
//        return http.build();
//    }
//}
