package com.yd.auth.core;

import com.yd.common.constant.ServerNameConstants;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.openfeign.EnableFeignClients;

@SpringBootApplication(scanBasePackages = "com.yd")
@MapperScan("com.yd.**.mapper")
@EnableFeignClients(basePackages = "com.yd")
public class AuthApplication {

    public static void main(String[] args) {
        new SpringApplicationBuilder(AuthApplication.class)
//                .properties("spring.config.name:bootstrap", "config/bootstrap.yml")
                .properties("spring.application.name="+ ServerNameConstants.ydAuthCore)
                .build().run(args);
        System.out.println("(♥◠‿◠)ﾉﾞ  yd-auth-core认证服务启动成功   ლ(´ڡ`ლ)ﾞ ");
    }
}
