package com.yd.auth.core.controller;

import com.yd.auth.core.dto.LoginRequest;
import com.yd.auth.core.dto.LoginResponse;
import com.yd.auth.core.service.AuthService;
import com.yd.common.result.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

@RestController
@RequestMapping("/auth")
public class AuthController {

    private final AuthService authService;

    @Autowired
    public AuthController(AuthService authService) {
        this.authService = authService;
    }

    @PostMapping("/login")
    public Result<LoginResponse> login(@Valid @RequestBody LoginRequest loginRequest) {
        LoginResponse response = authService.login(loginRequest);
        return Result.success(response);
    }

//    @PostMapping("/logout")
//    public Result<Void> logout() {
//        // 实际实现需要前端传递token
//        // 这里简化处理
//        return R.success("登出成功");
//    }
}
