package com.yd.auth.core.security;

import com.yd.auth.core.security.JwtAuthenticationToken;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

import java.util.ArrayList;
import java.util.List;

@Component
public class DummyAuthenticationManager implements ReactiveAuthenticationManager {

    @Override
    public Mono<Authentication> authenticate(Authentication authentication) {
        // 检查是否为 JwtAuthenticationToken 类型
        if (authentication instanceof JwtAuthenticationToken) {
            String token = (String) authentication.getCredentials();
            
            try {
                // 验证令牌有效性（实际项目中应调用 JwtUtils 验证）
                if (isValidToken(token)) {
                    // 从令牌中提取用户名和权限信息
                    String username = extractUsernameFromToken(token);
                    List<GrantedAuthority> authorities = extractAuthoritiesFromToken(token);
                    
                    // 创建已认证的令牌
                    JwtAuthenticationToken authenticatedToken = 
                        new JwtAuthenticationToken(username, authorities);
                    authenticatedToken.setDetails(authentication.getDetails());
                    
//                    return Mono.just(authenticatedToken);
                    return null;
                }
            } catch (Exception e) {
                return Mono.error(e);
            }
        }
        
        // 非 JWT 认证请求，返回空
        return Mono.empty();
    }
    
    // 实际项目中应调用 JwtUtils 验证令牌
    private boolean isValidToken(String token) {
        // 示例实现，实际应调用 JwtUtils.validateToken(token)
        return token != null && !token.isEmpty();
    }
    
    // 实际项目中应从令牌中解析用户名
    private String extractUsernameFromToken(String token) {
        // 示例实现，实际应调用 JwtUtils.getUsernameFromToken(token)
        return "test-user";
    }
    
    // 实际项目中应从令牌中解析权限
    private List<GrantedAuthority> extractAuthoritiesFromToken(String token) {
        // 示例实现，实际应调用 JwtUtils.getRolesFromToken(token)
        List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        authorities.add(new SimpleGrantedAuthority("ROLE_USER"));
        return authorities;
    }
}
