package com.yd.auth.core.service;

import com.yd.user.service.entity.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public interface UserService extends UserDetailsService {

    /**
     * 根据用户名加载用户详情
     */
    @Override
    UserDetails loadUserByUsername(String username) throws UsernameNotFoundException;

    /**
     * 根据用户名查找用户
     */
    User findByUsername(String username);

    /**
     * 注册新用户
     */
    User register(User user);
}
