package com.yd.common.utils;

import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import javax.servlet.http.HttpServletRequest;

public class TokenUtils {

    /**
     * 获取当前请求的token
     * @return
     */
    public static String getCurrentToken() {
        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            HttpServletRequest request = attributes.getRequest();
            // 从Header中获取token
            String token = request.getHeader("Authorization");
            if (token != null && token.startsWith("Bearer ")) {
                return token;
            }
            // 从参数中获取token
            token = request.getHeader("token");
            if (token != null) {
                return token;
            }
        }
        return null;
    }

}