package com.yd.auth.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.yd.auth.core.dto.AuthUserDto;
import com.yd.common.result.Result;
import com.yd.user.feign.client.sysuser.ApiSysUserFeignClient;
import com.yd.user.feign.request.sysuser.ApiSysUserDetailBodyRequest;
import com.yd.user.feign.response.sysuser.ApiSysUserDetailResponse;
import com.yd.user.service.model.SysUser;
import com.yd.user.service.service.ISysUserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * authenticationManager.authenticate(authentication) -->进行spring security 登录认证
 * --> spring security 登录认证会走到这里去获取用户表的数据进行用户名和密码对比返回最后认证是否成功的结果
 */

@Slf4j
@Service
public class AuthUserDetailsService implements UserDetailsService {

//    @Autowired
//    @Qualifier("sysUserServiceImpl")
//    private ISysUserService iSysUserService;

    @Autowired
    private ApiSysUserFeignClient apiSysUserFeignClient;

    @Override
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        //Spring Security用户认证对象
        AuthUserDto authUserDto = null;
        // 通过Feign调用yd-user-feign服务获取用户信息
        ApiSysUserDetailBodyRequest request = new ApiSysUserDetailBodyRequest();
        request.setUserName(username);
        Result<ApiSysUserDetailResponse> result = apiSysUserFeignClient.detail(request);
        log.info("loadUserByUsername获取用户信息:{}", JSON.toJSONString(result));
        if (Objects.isNull(result.getData())) {
            throw new UsernameNotFoundException("用户不存在");
        }
        ApiSysUserDetailResponse response = result.getData();
        authUserDto = new AuthUserDto();
        BeanUtils.copyProperties(response,authUserDto);
        authUserDto.setUsername(response.getUserName());
        // 查询用户角色 TODO
//        authUserDto.setRoles(roles);

        return authUserDto;
    }

//    @Override
//    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
//        //Spring Security用户认证对象
//        AuthUserDto authUserDto = null;
//        // 通过Feign调用yd-user-service服务获取用户信息
//        SysUser sysUser = iSysUserService.queryOneByName(username);
//        if (Objects.isNull(sysUser)) {
//            throw new UsernameNotFoundException("用户不存在");
//        }
//        authUserDto = new AuthUserDto();
//        BeanUtils.copyProperties(sysUser,authUserDto);
//        authUserDto.setUsername(sysUser.getUserName());
//        // 查询用户角色 TODO
////        authUserDto.setRoles(roles);
//
//        return authUserDto;
//    }
}
