package com.yd.common.utils;

import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.util.encoders.Hex;
import java.security.*;

/**
 * SM2国密算法工具类
 */
public class SM2Util {

    static {
        Security.addProvider(new BouncyCastleProvider());
    }

    // 生成SM2密钥对
    public static KeyPair generateKeyPair() throws Exception {
        ECParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec("sm2p256v1");
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC", "BC");
        kpg.initialize(ecSpec, new SecureRandom());
        return kpg.generateKeyPair();
    }

    // SM2加密
    public static String encrypt(String publicKeyHex, String data) throws Exception {
        ECPublicKeyParameters publicKey = getPublicKeyFromHex(publicKeyHex);
        SM2Engine engine = new SM2Engine();
        engine.init(true, new ParametersWithRandom(publicKey, new SecureRandom()));

        byte[] dataBytes = data.getBytes();
        byte[] encrypted = engine.processBlock(dataBytes, 0, dataBytes.length);
        return Hex.toHexString(encrypted);
    }

    // SM2解密
    public static String decrypt(String privateKeyHex, String encryptedData) throws Exception {
        ECPrivateKeyParameters privateKey = getPrivateKeyFromHex(privateKeyHex);
        SM2Engine engine = new SM2Engine();
        engine.init(false, privateKey);

        byte[] encryptedBytes = Hex.decode(encryptedData);
        byte[] decrypted = engine.processBlock(encryptedBytes, 0, encryptedBytes.length);
        return new String(decrypted);
    }

    // 从十六进制字符串获取公钥
    private static ECPublicKeyParameters getPublicKeyFromHex(String publicKeyHex) {
        // 实现细节省略
        return null;
    }

    // 从十六进制字符串获取私钥
    private static ECPrivateKeyParameters getPrivateKeyFromHex(String privateKeyHex) {
        // 实现细节省略
        return null;
    }
}
