package com.yd.common.utils;

import com.yd.common.enums.CommonEnum;
import java.security.SecureRandom;
import java.util.Random;

/**
 * 业务id生成工具类
 */
public class RandomStringGenerator {
    // 包含所有数字和字母（大小写）的字符池
    private static final String CHAR_POOL = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final SecureRandom secureRandom = new SecureRandom();
    private static final Random random = new Random();

    /**
     * 生成随机字符串
     * @param length 字符串长度
     * @param useSecureRandom 是否使用安全随机生成器
     * @return 随机字符串
     */
    public static String generate(int length, boolean useSecureRandom) {

        StringBuilder sb = new StringBuilder(length);
        Random rand = useSecureRandom ? secureRandom : random;
        
        for (int i = 0; i < length; i++) {
            // 从字符池中随机选取字符
            int randomIndex = rand.nextInt(CHAR_POOL.length());
            sb.append(CHAR_POOL.charAt(randomIndex));
        }
        
        return sb.toString();
    }

    /**
     * 生成（业务标识类型+32位随机字符串）业务唯一标识id
     * @param uidType 业务标识类型
     * @return 业务标识类型+32位随机字符串
     */
    public static String generateBizId32(String uidType) {
        return uidType + "_" + generate(32,true);
    }

    /**
     * 生成（业务标识类型+16位随机字符串）业务唯一标识id
     * @param uidType 业务标识类型
     * @return 业务标识类型+16位随机字符串
     */
    public static String generateBizId16(String uidType) {
        return uidType + "_" + generate(16,true);
    }

    public static void main(String[] args) {
//        // 生成16位随机字符串（使用安全随机）
//        String random16 = generate(16, true);
//        System.out.println("16位: " + random16);
//
//        // 生成32位随机字符串（使用普通随机）
//        String random32 = generate(32, false);
//        System.out.println("32位: " + random32);

        for (int i = 0; i < 9; i++) {
            System.out.println(generateBizId16("cffp_poster"));
        }

    }
}
