package com.yd.common.enums;

import java.util.Arrays;

/**
 * 是否枚举
 */
public enum NoYesEnum {

    //是否枚举
    NO("否","0"),
    YES("是","1"),
    ;

    //字典项标签（名称）
    private String itemLabel;
    //字典项值
    private String itemValue;

    //构造函数
    NoYesEnum(String itemLabel, String itemValue) {
        this.itemLabel = itemLabel;
        this.itemValue = itemValue;
    }

    public String getItemLabel() {
        return itemLabel;
    }

    public String getItemValue() {
        return itemValue;
    }

    /**
     * 根据itemValue获取对应的itemLabel
     * @param itemValue 字典值
     * @return 对应的字典标签，如果未找到则返回空字符串
     */
    public static String getLabelByValue(String itemValue) {
        return Arrays.stream(values())
                .filter(noYesEnum -> noYesEnum.itemValue.equals(itemValue))
                .findFirst()
                .map(NoYesEnum::getItemLabel)
                .orElse("");
    }
}
