package com.yd.common.utils;

import com.ibm.icu.text.Transliterator;

/**
 * 繁体字转简体中文工具类
 * 使用 ICU4J 实现
 */
public class ChineseTextConverter {
    
    private static final Transliterator TRADITIONAL_TO_SIMPLIFIED;
    private static final Transliterator SIMPLIFIED_TO_TRADITIONAL;
    
    static {
        // 初始化转换器
        TRADITIONAL_TO_SIMPLIFIED = Transliterator.getInstance("Traditional-Simplified");
        SIMPLIFIED_TO_TRADITIONAL = Transliterator.getInstance("Simplified-Traditional");
    }

    /**
     * 繁体转简体
     * @param traditionalText
     * @return
     */
    public static String traditionalToSimplified(String traditionalText) {
        if (traditionalText == null || traditionalText.trim().isEmpty()) {
            return traditionalText;
        }
        
        try {
            return TRADITIONAL_TO_SIMPLIFIED.transliterate(traditionalText);
        } catch (Exception e) {
            System.err.println("转换失败: " + e.getMessage());
            return traditionalText;
        }
    }

    /**
     * 简体转繁体
     * @param simplifiedText
     * @return
     */
    public static String simplifiedToTraditional(String simplifiedText) {
        if (simplifiedText == null || simplifiedText.trim().isEmpty()) {
            return simplifiedText;
        }
        
        try {
            return SIMPLIFIED_TO_TRADITIONAL.transliterate(simplifiedText);
        } catch (Exception e) {
            System.err.println("转换失败: " + e.getMessage());
            return simplifiedText;
        }
    }

    public static void main(String[] args) {
        System.out.println(simplifiedToTraditional("联络电话"));
    }
}