package com.yd.common.enums;


/**
 * 返回码
 *
 * @author zxm
 */
public enum ResultCode {

    SUCCESS(200,"操作成功","") ,
    FAIL(500,"操作失败","") ,
    NULL_ERROR(201,"数据不存在","") ,
    TENANT_NAME_EXISTS(202,"租户名称已存在","") ,
    PROJECT_NAME_EXISTS(203,"项目名称已存在","") ,
    ROLE_NAME_EXISTS(204,"角色名称已存在","") ,
    MENU_NAME_EXISTS(205,"菜单名称已存在","") ,
    DEPT_NAME_EXISTS(206,"部门名称已存在","") ,
    PRODUCT_NAME_EXISTS(207,"保险产品名称已存在","") ,
    PLAN_NAME_EXISTS(208,"保险产品计划名称已存在","") ,
    ADDITIONAL_PRODUCT_NAME_EXISTS(209,"保险附加产品名称已存在","") ,
    USER_NOT_EXISTS(300,"用户不存在","") ,
    PARAM_CHECK_ERROR(4001,"参数校验异常",""),
    PARAMS_ERROR(40000, "请求参数错误",""),
    NOT_LOGIN_ERROR(40100, "未登录",""),
    NO_AUTH_ERROR(40101, "无权限",""),
    FORBIDDEN_ERROR(40300, "禁止访问",""),

    ;
    //返回码
    private final int code;
    //操作响应信息
    private final String message;
    //响应信息的详细描述
    private final String description;

    //构造函数
    ResultCode(int code, String message, String description) {
        this.code = code;
        this.message = message;
        this.description = description;
    }
    //get方法
    public int getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    public String getDescription() {
        return description;
    }
}
