package com.yd.auth.core.config;

import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

/**
 * 自定义密码加密器，实现自定义的密码比对逻辑
 */
@Component
public class CustomPasswordEncoder implements PasswordEncoder {

    /**
     * 加密方法：这里简化处理，直接返回原始密码（实际项目中建议加密）
     * @param rawPassword 原始密码（用户输入的明文）
     * @return 加密后的密码（这里返回明文，仅作示例）
     */
    @Override
    public String encode(CharSequence rawPassword) {
        // 实际业务中，建议在这里实现你的加密逻辑（如加盐MD5、SHA等）
        return rawPassword.toString();
    }

    /**
     * 密码比对方法：自定义比对逻辑
     * @param rawPassword 前端传参的密码（用户输入的明文）
     * @param encodedPassword 数据库中存储的密码（可能是加密后的）
     * @return 比对结果（true表示一致，false表示不一致）
     */
    @Override
    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        // 自定义比对逻辑：例如直接比较两个字符串是否相等
        // 注意：实际项目中需根据加密规则解密后比对，或加密输入密码后比对
        return rawPassword.toString().equals(encodedPassword);
    }
}
