/*
 * Decompiled with CFR 0.152.
 */
package com.yd.auth.core.security;

import com.yd.auth.core.security.JwtAuthenticationToken;
import com.yd.auth.core.utils.JwtUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Component;

@Component
public class JwtAuthenticationProvider
implements AuthenticationProvider {
    @Autowired
    private JwtUtils jwtUtils;
    @Autowired
    private UserDetailsService userDetailsService;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String token = (String)authentication.getCredentials();
        try {
            if (!this.jwtUtils.validateToken(token).booleanValue()) {
                throw new BadCredentialsException("\u65e0\u6548\u7684\u4ee4\u724c");
            }
            String username = this.jwtUtils.getUsernameFromToken(token);
            UserDetails userDetails = this.userDetailsService.loadUserByUsername(username);
            List<String> roles = this.jwtUtils.getRolesFromToken(token);
            ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
            for (String role : roles) {
                authorities.add(new SimpleGrantedAuthority(role));
            }
            JwtAuthenticationToken authenticatedToken = new JwtAuthenticationToken(userDetails, authorities);
            authenticatedToken.setDetails(authentication.getDetails());
            return authenticatedToken;
        }
        catch (Exception e) {
            throw new BadCredentialsException("\u8ba4\u8bc1\u5931\u8d25", (Throwable)e);
        }
    }

    public boolean supports(Class<?> authentication) {
        return JwtAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

