package com.yd.gateway;

import com.yd.common.constant.ServerNameConstants;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorMvcAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.openfeign.EnableFeignClients;

/**
 * 网关启动程序
 */
@SpringBootApplication(
        scanBasePackages = "com.yd",
        exclude = {
                // 排除 Spring MVC 相关自动配置
                WebMvcAutoConfiguration.class,
                ErrorMvcAutoConfiguration.class,
                org.springframework.boot.autoconfigure.web.servlet.DispatcherServletAutoConfiguration.class,
                org.springframework.boot.autoconfigure.web.servlet.HttpEncodingAutoConfiguration.class
        }
)
@EnableFeignClients(basePackages = "com.yd")
public class GatewayApplication {
    public static void main(String[] args) {
        new SpringApplicationBuilder(GatewayApplication.class)
                .properties(
                        "spring.application.name=" + ServerNameConstants.ydGateway,
                        // 强制设置响应式模式
                        "spring.main.web-application-type=reactive",
                        "spring.main.allow-bean-definition-overriding=true",
                        "spring.main.allow-circular-references=true"
                )
                .build().run(args);
        System.out.println("(♥◠‿◠)ﾉﾞ  yd-gateway网关启动成功   ლ(´ڡ`ლ)ﾞ ");
    }
}