/*
 * Decompiled with CFR 0.152.
 */
package com.yd.auth.core.service.impl;

import com.yd.auth.core.security.JwtAuthenticationToken;
import com.yd.auth.core.service.AuthService;
import com.yd.auth.core.utils.JwtUtils;
import com.yd.user.service.entity.User;
import com.yd.user.service.service.UserService;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Service
public class AuthServiceImpl
implements AuthService {
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private JwtUtils jwtUtils;
    @Autowired
    private UserService userService;

    @Override
    public Map<String, String> login(String username, String password) {
        Authentication authentication = this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
        SecurityContextHolder.getContext().setAuthentication(authentication);
        UserDetails userDetails = (UserDetails)authentication.getPrincipal();
        String token = this.jwtUtils.generateToken(userDetails);
        String refreshToken = this.jwtUtils.generateRefreshToken(userDetails);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("token", token);
        result.put("refreshToken", refreshToken);
        return result;
    }

    @Override
    public Map<String, String> refreshToken(String refreshToken) {
        if (!this.jwtUtils.validateToken(refreshToken).booleanValue()) {
            throw new RuntimeException("\u65e0\u6548\u7684\u5237\u65b0\u4ee4\u724c");
        }
        String username = this.jwtUtils.getUsernameFromToken(refreshToken);
        UserDetails userDetails = this.userService.loadUserByUsername(username);
        String token = this.jwtUtils.generateToken(userDetails);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("token", token);
        result.put("refreshToken", refreshToken);
        return result;
    }

    @Override
    public Authentication validateToken(String token) {
        JwtAuthenticationToken authentication = new JwtAuthenticationToken(token);
        return this.authenticationManager.authenticate((Authentication)authentication);
    }

    @Override
    public User register(User user) {
        return this.userService.register(user);
    }
}

