package com.yd.auth.core.controller;

import com.yd.auth.core.request.LoginRequest;
import com.yd.auth.core.response.LoginResponse;
import com.yd.auth.core.service.AuthService;
import com.yd.common.result.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * 认证信息
 */
@RestController
@RequestMapping("/auth")
@Validated
public class AuthController {

    @Autowired
    private AuthService authService;

    /**
     * 登录（spring security登录认证）
     * @param loginRequest
     * @return
     */
    @PostMapping("/login")
    public Result<LoginResponse> login(@RequestBody LoginRequest loginRequest) {
        LoginResponse response = authService.login(loginRequest);
        return Result.success(response);
    }

}
