package com.yd.feign.config;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import javax.servlet.http.HttpServletRequest;

@Component
public class FeignTokenInterceptor implements RequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(FeignTokenInterceptor.class);

    @Override
    public void apply(RequestTemplate template) {
        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();

        if (attributes == null) {
            logger.debug("RequestContextHolder没有找到请求属性，跳过Token传递");
            return;
        }

        HttpServletRequest request = attributes.getRequest();
        String token = request.getHeader("Authorization");

        if (token != null && !token.trim().isEmpty()) {
            template.header("Authorization", token);
            logger.debug("已添加Authorization头到Feign请求");
        } else {
            logger.debug("当前请求中没有Authorization头，跳过Token传递");
        }
    }
}
