package com.yd.common.config.fegin;

import com.yd.common.interceptor.FeignRequestInterceptor;
import feign.Logger;
import feign.RequestInterceptor;
import feign.Retryer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * fegin配置
 */
@Configuration
public class FeginConfig {

    @Bean
    public Logger.Level feignLoggerLevel() {
        return Logger.Level.BASIC;
    }
    @Bean
    Logger feignLogger() {
        return new FeginLogger(); // 你的继承类
    }

    @Bean
    public Retryer.Default retryerDefault(){
        return new Retryer.Default();
    }


    @Bean
    public RequestInterceptor requestInterceptor()
    {
        return new FeignRequestInterceptor();
    }
}
