package com.yd.fileservice;

import com.yd.common.constant.WeServerNameConstants;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceTransactionManagerAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;


/**
 * 文件服务
 *
 */
@SpringBootApplication(exclude = {DataSourceAutoConfiguration.class,
        DataSourceTransactionManagerAutoConfiguration.class,
        HibernateJpaAutoConfiguration.class})
public class FileApplication {
    public static void main(String[] args) {
        new SpringApplicationBuilder(FileApplication.class)
                .properties("spring.config.name:bootstrap", "config/bootstrap.yml")
                .properties("spring.application.name="+ WeServerNameConstants.ydFile)
                .build().run(args);
        System.out.println("(♥◠‿◠)ﾉﾞ  yd-fileservice启动成功   ლ(´ڡ`ლ)ﾞ ");
    }



}
