package com.yd.scheduler;

import com.yd.common.config.fegin.FeginConfig;
import com.yd.common.constant.WeServerNameConstants;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableAsync;

@EnableAsync
@ComponentScan("com.yd.**")
@MapperScan("com.yd.**.mapper")
@EnableFeignClients(basePackages="com.yd.**",defaultConfiguration = FeginConfig.class)
@SpringBootApplication
public class SchedulerApplication {
    public static void main(String[] args) {
        new SpringApplicationBuilder(SchedulerApplication.class)
                .properties("spring.config.name:bootstrap", "config/bootstrap.yml")
                .properties("spring.application.name="+ WeServerNameConstants.ydScheduler)
                .build().run(args);
        System.out.println("(♥◠‿◠)ﾉﾞ  yd-scheduler启动成功   ლ(´ڡ`ლ)ﾞ ");
    }
}
