package com.yd.scrm.api;

import com.github.pagehelper.autoconfigure.PageHelperAutoConfiguration;
import com.yd.common.config.fegin.FeginConfig;
import com.yd.common.constant.WeServerNameConstants;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.scheduling.annotation.EnableAsync;

@MapperScan("com.yd.**.mapper")
@SpringBootApplication(exclude = {PageHelperAutoConfiguration.class})
@EnableAsync
@EnableFeignClients(defaultConfiguration = FeginConfig.class)
public class ApiApplication {
    public static void main(String[] args) {

        new SpringApplicationBuilder(ApiApplication.class)
                .properties("spring.config.name:bootstrap", "config/bootstrap.yml")
                .properties("spring.application.name="+ WeServerNameConstants.ydApi)
                .build().run(args);
        System.out.println("(♥◠‿◠)ﾉﾞ  yd-scrm-api启动成功   ლ(´ڡ`ლ)ﾞ ");

    }

}
