package com.yd.csf.wx.feign.request.login;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;

@Data
public class ApiPhoneCodeLoginRequest {

    /**
     * 手机号
     */
    @NotBlank(message = "手机号不能为空")
    @Pattern(regexp = "^(?:(?:\\+|00)86)?1[3-9]\\d{9}$", message = "手机号格式不正确")
    private String phone;

    /**
     * 手机号验证码
     */
    @NotBlank(message = "手机号验证码不能为空")
    private String phoneCode;

    /**
     * 推荐人的邀请码，推荐链接带入进来，有值表示通过邀请加入，无值表示直接打开小程序
     */
    private String invitationCode;
}
