package com.yd.csf.wx.feign.request.login;

import lombok.Data;

import javax.validation.constraints.NotBlank;

@Data
public class ApiWxLoginRequest {

    /**
     * 前端调用wx.login获取code，用于后端交换openid和session_key
     */
    @NotBlank(message = "code不能为空")
    private String code;

    /**
     * 用户手机号的加密数据（微信小程序自动生成）
     */
    @NotBlank(message = "encryptedData不能为空")
    private String encryptedData;

    /**
     * AES加密算法的初始向量，用于解密 encryptedData
     */
    @NotBlank(message = "iv不能为空")
    private String iv;

    /**
     * 推荐人的邀请码，推荐链接带入进来，有值表示通过邀请加入，无值表示直接打开小程序
     */
    private String invitationCode;
}
