package com.yd.csf.wx.feign.request.user;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class ApiApprovalAccountRequest {

    /**
     * 被审批的客户端用户表唯一业务ID
     */
    @NotBlank(message = "被审批的客户端用户表唯一业务ID不能为空")
    private String clientUserBizId;

    /**
     * 审批状态：0-拒绝 1-同意
     */
    @NotNull(message = "审批状态不能为空")
    private Integer status;

    /**
     * 备注
     */
    private String remark;
}
