package com.yd.csf.wx.feign.request.user;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;
import java.util.List;

@Data
public class ApiUserImproveRequest {

    /**
     * 头像
     */
    private String avatar;

    /**
     * 姓名
     */
    @NotBlank(message = "姓名不能为空")
    private String name;

    /**
     * 证件类型
     */
    @NotBlank(message = "证件类型不能为空")
    private String idCardType;

    /**
     * 证件号码
     */
    @NotBlank(message = "证件号码不能为空")
    private String idCardNumber;

    /**
     * 证件文件url列表
     */
    @NotEmpty(message = "证件文件url不能为空")
    private List<String> idCardFileUrlList;

    /**
     * 银行卡号
     */
    @NotBlank(message = "银行卡号不能为空")
    private String bankNumber;

    /**
     * 开户行
     */
    @NotBlank(message = "开户行不能为空")
    private String openBank;

    /**
     * 银行卡文件url（多个分号分开）
     */
    @NotEmpty(message = "银行卡文件url不能为空")
    private List<String> bankFileUrlList;

    /**
     * 手机号
     */
    @NotBlank(message = "手机号不能为空")
    @Pattern(regexp = "^(?:(?:\\+|00)86)?1[3-9]\\d{9}$", message = "手机号格式不正确")
    private String phone;

    /**
     * 推荐人的邀请码，推荐链接带入进来，有值表示通过邀请加入，无值表示直接打开小程序
     */
    @NotBlank(message = "推荐人的邀请码不能为空")
    private String invitationCode;

    /**
     * 小程序的openId
     */
    private String openId;
}
