package com.yd.csf.wx.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.auth.core.config.LoginConfig;
import com.yd.auth.core.dto.AuthUserDto;
import com.yd.auth.core.security.JwtTokenProvider;
import com.yd.common.constant.RedisConstants;
import com.yd.common.enums.CommonEnum;
import com.yd.common.enums.ProjectEnum;
import com.yd.common.enums.TenantEnum;
import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.common.utils.RedisUtil;
import com.yd.csf.wx.api.service.ApiLoginService;
import com.yd.csf.wx.api.service.ApiUserService;
import com.yd.csf.wx.feign.dto.TokenDto;
import com.yd.csf.wx.feign.enums.RedirectPageEnum;
import com.yd.csf.wx.feign.request.login.ApiPhoneCodeLoginRequest;
import com.yd.csf.wx.feign.response.login.ApiPhoneCodeLoginResponse;
import com.yd.user.feign.client.clientuser.ApiClientUserFeignClient;
import com.yd.user.feign.request.clientuser.ApiClientUserPageRequest;
import com.yd.user.feign.response.clientuser.ApiClientUserPageResponse;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@Slf4j
@Service
public class ApiLoginServiceImpl implements ApiLoginService {

    @Autowired
    private ApiClientUserFeignClient apiClientUserFeignClient;

    @Autowired
    private JwtTokenProvider jwtTokenProvider;

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private LoginConfig loginConfig;

    @Autowired
    private ApiUserService apiUserService;

    /**
     * 手机验证码登录
     * @param request
     * @return
     */
    @Override
    public Result<ApiPhoneCodeLoginResponse> phoneCodeLogin(ApiPhoneCodeLoginRequest request) {
        ApiPhoneCodeLoginResponse loginResponse = new ApiPhoneCodeLoginResponse();
        //TODO 校验手机号验证码是否正确 - redis缓存
        //调用yd-user-api服务，查询客户端用户表信息，查询当前租户项目下是否有客户端手机号用户
        ApiClientUserPageResponse response = apiUserService.getApiClientUserPageResponse(request.getPhone(),"");
        if (!Objects.isNull(response)) {
            //有客户端手机号用户数据：判断审批状态是否审批成功，审批成功直接到首页，其他状态到审批进度页面
            if (CommonEnum.APPROVAL_STATUS_CG.getCode().equals(response.getApprovalStatus())) {
                //审批成功 - 跳转到首页
                loginResponse.setRedirectPage(RedirectPageEnum.HOME_PAGE.getItemValue());
            }else {
                //其他状态 - 审批进度页
                loginResponse.setRedirectPage(RedirectPageEnum.PROGRESS.getItemValue());
            }
            //生成客户端用户登录token
            TokenDto tokenDto = generateToken(response);
            loginResponse.setTokenDto(tokenDto);
        }else {
            //无客户端手机号用户数据：判断入参有无推荐人邀请码，无推荐人邀请码则提示无权限登录。有推荐人邀请码到完善信息注册登录
            if (StringUtils.isBlank(request.getInvitationCode())) {
                throw new BusinessException("无权限登录!");
            }
            //有推荐人邀请码到完善信息页
            loginResponse.setRedirectPage(RedirectPageEnum.IMPROVE.getItemValue());
        }

        return Result.success(loginResponse);
    }

    /**
     * 生成客户端用户登录token
     * @param response
     * @return
     */
    public TokenDto generateToken(ApiClientUserPageResponse response) {
        //生成JWT令牌
        String token = jwtTokenProvider.generateToken(response.getClientUserBizId());
        log.info("生成JWT令牌:{}", token);
        TokenDto tokenDto = new TokenDto();
        //设置生成的JWT令牌
        tokenDto.setToken(token);
        // 设置令牌过期时间
        tokenDto.setExpiresIn(jwtTokenProvider.getJwtExpiration());

        //获取用户登录信息存入redis缓存中
        AuthUserDto currentUser = (AuthUserDto) queryUserDetails(response);
        redisUtil.setCacheObject(RedisConstants.LOGIN_USER + response.getClientUserBizId(),currentUser,loginConfig.getRedisTimeout(), TimeUnit.DAYS);
        return tokenDto;
    }

    /**
     * 客户端用户信息构造spring security认证对象UserDetails
     * @param response
     * @return spring security认证对象UserDetails
     */
    public UserDetails queryUserDetails(ApiClientUserPageResponse response) {
        AuthUserDto authUserDto = new AuthUserDto();
        BeanUtils.copyProperties(response,authUserDto);
        // 查询用户角色 TODO
//        authUserDto.setRoles(roles);

        return authUserDto;
    }


}
