package com.yd.csf.wx.feign.fallback.login;

import com.yd.common.result.Result;
import com.yd.csf.wx.feign.client.login.ApiLoginFeignClient;
import com.yd.csf.wx.feign.request.login.ApiPhoneCodeLoginRequest;
import com.yd.csf.wx.feign.response.login.ApiPhoneCodeLoginResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 香港保险小程序端服务-登录信息Feign降级处理
 */
@Slf4j
@Component
public class ApiLoginFeignFallbackFactory implements FallbackFactory<ApiLoginFeignClient> {
    @Override
    public ApiLoginFeignClient create(Throwable cause) {
        return new ApiLoginFeignClient() {
            @Override
            public Result<ApiPhoneCodeLoginResponse> phoneCodeLogin(ApiPhoneCodeLoginRequest request) {
                return null;
            }
        };
    }
}
