package com.yd.csf.wx.feign.fallback.user;

import com.yd.common.result.Result;
import com.yd.csf.wx.feign.client.user.ApiUserFeignClient;
import com.yd.csf.wx.feign.request.user.ApiApprovalAccountPageRequest;
import com.yd.csf.wx.feign.request.user.ApiApprovalAccountRequest;
import com.yd.csf.wx.feign.request.user.ApiUserImproveRequest;
import com.yd.csf.wx.feign.response.user.ApiUserDetailResponse;
import com.yd.csf.wx.feign.response.user.ApiUserImproveResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 香港保险小程序端服务-个人信息Feign降级处理
 */
@Slf4j
@Component
public class ApiUserFeignFactory implements FallbackFactory<ApiUserFeignClient> {
    @Override
    public ApiUserFeignClient create(Throwable cause) {
        return new ApiUserFeignClient() {
            @Override
            public Result<ApiUserImproveResponse> userImprove(ApiUserImproveRequest request) {
                return null;
            }

            @Override
            public Result approvalAccountPage(ApiApprovalAccountPageRequest request) {
                return null;
            }

            @Override
            public Result approvalAccount(ApiApprovalAccountRequest request) {
                return null;
            }

            @Override
            public Result<ApiUserDetailResponse> detail() {
                return null;
            }
        };
    }
}
