package com.yd.csf.wx.feign.response.user;

import lombok.Data;
import java.util.List;

@Data
public class ApiUserDetailResponse {

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 客户端用户表唯一业务ID
     */
    private String clientUserBizId;

    /**
     * 头像
     */
    private String avatar;

    /**
     * 姓名
     */
    private String name;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 证件类型
     */
    private String idCardType;

    /**
     * 证件号码
     */
    private String idCardNumber;

    /**
     * 证件文件url列表
     */
    private List<String> idCardFileUrlList;

    /**
     * 银行卡号
     */
    private String bankNumber;

    /**
     * 开户行
     */
    private String openBank;

    /**
     * 银行卡文件url列表
     */
    private List<String> bankFileUrlList;

    /**
     * 登录密码
     */
    private String password;

    /**
     * 邀请码
     */
    private String invitationCode;

    /**
     * 状态(0:停用 1:启用)
     */
    private Integer status;

    /**
     * 审批状态
     */
    private String approvalStatus;

    /**
     * 注册来源（PC、小程序等）默认小程序 - MINI_PROGRAM
     */
    private String registerSource;

    /**
     * 所属租户唯一业务ID（冗余）
     */
    private String tenantBizId;

    /**
     * 所属项目唯一业务ID（冗余）
     */
    private String projectBizId;

}
