package com.yd.csf.wx.api;

import com.yd.common.constant.ServerNameConstants;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.openfeign.EnableFeignClients;

@SpringBootApplication(scanBasePackages = "com.yd")
@MapperScan("com.yd.**.dao")
@EnableFeignClients(basePackages = "com.yd")
public class CsfWxApiApplication {

    public static void main(String[] args) {
        new SpringApplicationBuilder(CsfWxApiApplication.class)
                .properties("spring.application.name="+ ServerNameConstants.ydCsfWxApi)
                .build().run(args);
        System.out.println("(♥◠‿◠)ﾉﾞ  yd-csf-wx-api启动成功   ლ(´ڡ`ლ)ﾞ ");
    }
}
