package com.yd.csf.wx.api.controller;

import com.yd.common.result.Result;
import com.yd.csf.wx.api.service.ApiLoginService;
import com.yd.csf.wx.feign.client.login.ApiLoginFeignClient;
import com.yd.csf.wx.feign.request.login.ApiPhoneCodeLoginRequest;
import com.yd.csf.wx.feign.request.login.ApiWxLoginRequest;
import com.yd.csf.wx.feign.response.login.ApiPhoneCodeLoginResponse;
import com.yd.csf.wx.feign.response.login.ApiWxLoginResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 登录信息
 *
 * @author zxm
 * @since 2025-10-21
 */
@RestController
@RequestMapping("/login")
@Validated
public class ApiLoginController implements ApiLoginFeignClient {

    @Autowired
    private ApiLoginService apiLoginService;

    /**
     * 手机验证码登录
     * @param request
     * @return
     */
    @Override
    public Result<ApiPhoneCodeLoginResponse> phoneCodeLogin(ApiPhoneCodeLoginRequest request) {
        return apiLoginService.phoneCodeLogin(request);
    }

    /**
     * 微信小程序手机号快捷验证登录
     * @param request
     * @return
     */
    @Override
    public Result<ApiWxLoginResponse> wxLogin(ApiWxLoginRequest request) {
        return apiLoginService.wxLogin(request);
    }
}
