package com.yd.csf.wx.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.csf.wx.api.service.ApiUserService;
import com.yd.csf.wx.feign.client.user.ApiUserFeignClient;
import com.yd.csf.wx.feign.request.user.ApiApprovalAccountPageRequest;
import com.yd.csf.wx.feign.request.user.ApiApprovalAccountRequest;
import com.yd.csf.wx.feign.request.user.ApiUserImproveRequest;
import com.yd.csf.wx.feign.response.user.ApiApprovalAccountPageResponse;
import com.yd.csf.wx.feign.response.user.ApiUserDetailResponse;
import com.yd.csf.wx.feign.response.user.ApiUserImproveResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 个人信息
 *
 * @author zxm
 * @since 2025-10-21
 */
@RestController
@RequestMapping("/user")
@Validated
public class ApiUserController implements ApiUserFeignClient {

    @Autowired
    private ApiUserService apiUserService;

    /**
     * 完善信息
     * @param request
     * @return
     */
    @Override
    public Result<ApiUserImproveResponse> userImprove(ApiUserImproveRequest request) {
        return apiUserService.userImprove(request);
    }

    /**
     * 审批账号列表查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiApprovalAccountPageResponse>> approvalAccountPage(ApiApprovalAccountPageRequest request) {
        return apiUserService.approvalAccountPage(request);
    }

    /**
     * 审批账号
     * @param request
     * @return
     */
    @Override
    public Result approvalAccount(ApiApprovalAccountRequest request) {
        return apiUserService.approvalAccount(request);
    }

    /**
     * 当前登录客户端用户详情
     * @return
     */
    @Override
    public Result<ApiUserDetailResponse> detail() {
        return apiUserService.detail();
    }


}
