package com.yd.csf.wx.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.auth.core.dto.AuthUserDto;
import com.yd.auth.core.utils.SecurityUtil;
import com.yd.common.enums.CommonEnum;
import com.yd.common.enums.ProjectEnum;
import com.yd.common.enums.TenantEnum;
import com.yd.common.result.Result;
import com.yd.csf.feign.client.agentreferralrelation.ApiAgentReferralRelationFeignClient;
import com.yd.csf.feign.request.agentreferralrelation.ApiAgentReferralRelationSaveRequest;
import com.yd.csf.service.dto.AgentReferralRelationDto;
import com.yd.csf.service.model.AgentReferralRelation;
import com.yd.csf.service.service.IAgentReferralRelationService;
import com.yd.csf.wx.api.service.ApiUserService;
import com.yd.csf.wx.feign.request.user.ApiApprovalAccountPageRequest;
import com.yd.csf.wx.feign.request.user.ApiApprovalAccountRequest;
import com.yd.csf.wx.feign.request.user.ApiUserImproveRequest;
import com.yd.csf.wx.feign.response.user.ApiApprovalAccountPageResponse;
import com.yd.csf.wx.feign.response.user.ApiUserDetailResponse;
import com.yd.csf.wx.feign.response.user.ApiUserImproveResponse;
import com.yd.user.feign.client.clientuser.ApiClientUserFeignClient;
import com.yd.user.feign.request.clientuser.ApiClientUserEditApprovalStatusRequest;
import com.yd.user.feign.request.clientuser.ApiClientUserPageRequest;
import com.yd.user.feign.request.clientuser.ApiClientUserSaveRequest;
import com.yd.user.feign.response.clientuser.ApiClientUserDetailResponse;
import com.yd.user.feign.response.clientuser.ApiClientUserPageResponse;
import com.yd.user.feign.response.clientuser.ApiClientUserSaveResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ApiUserServiceImpl implements ApiUserService {

    @Autowired
    private ApiClientUserFeignClient apiClientUserFeignClient;

    @Autowired
    private ApiAgentReferralRelationFeignClient apiAgentReferralRelationFeignClient;

    @Autowired
    private IAgentReferralRelationService iAgentReferralRelationService;

    /**
     * 完善信息
     * @param request
     * @return
     */
    @Override
    public Result<ApiUserImproveResponse> userImprove(ApiUserImproveRequest request) {
        ApiClientUserPageResponse pageResponse = getApiClientUserPageResponse(request.getPhone(),"");
        ApiClientUserSaveRequest saveRequest = new ApiClientUserSaveRequest();
        BeanUtils.copyProperties(request,saveRequest);
        if (!Objects.isNull(pageResponse)) {
            //有客户端用户数据，编辑
            saveRequest.setClientUserBizId(pageResponse.getClientUserBizId());
        }else {
            //没有客户端用户数据，新增
            saveRequest.setClientUserBizId("");
        }
        //审批状态 - 待同意（需要推荐人同意才能到管理端运营去审核）
        saveRequest.setApprovalStatus(CommonEnum.APPROVAL_STATUS_DTY.getCode());
        saveRequest.setBankFileUrlList(request.getBankFileUrlList());
        saveRequest.setIdCardFileUrlList(request.getIdCardFileUrlList());
        //保存账号信息 - 更新审批状态为待同意状态，需要推荐人审核同意
        Result<ApiClientUserSaveResponse> result = apiClientUserFeignClient.save(saveRequest);
        //被推荐人客户端用户信息
        ApiClientUserSaveResponse saveResponse = result.getData();
        //保存推荐关系信息
        //查询推荐人客户端用户信息
        ApiClientUserPageResponse pageResponse1 = getApiClientUserPageResponse("",request.getInvitationCode());
        //被推荐人ID（客户端用户表唯一业务ID）列表
        List<String> agentIdList = new ArrayList<>();
        String referrerId = "";
        String referrerAccount = "";
        if (!Objects.isNull(saveResponse)) {
            agentIdList.add(saveResponse.getClientUserBizId());
        }
        if (!Objects.isNull(pageResponse1)) {
            referrerId = pageResponse1.getClientUserBizId();
            referrerAccount = pageResponse1.getPhone();
        }
        //保存推荐关系
        saveAgentReferralRelation(agentIdList,referrerId,referrerAccount);
        return Result.success();
    }

    /**
     * 审批账号列表查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiApprovalAccountPageResponse>> approvalAccountPage(ApiApprovalAccountPageRequest request) {
        IPage<ApiApprovalAccountPageResponse> iPage = new Page<ApiApprovalAccountPageResponse>();
        //查询被推荐人的用户业务ID列表 - 根据当前登录人作为推荐人查询
        AuthUserDto authUserDto = SecurityUtil.getCurrentLoginUser();
        //查询被推荐人列表
        List<AgentReferralRelation> relations = iAgentReferralRelationService.queryList(AgentReferralRelationDto.builder().referrerId(authUserDto.getClientUserBizId()).build());
        if (!CollectionUtils.isEmpty(relations)) {
            List<String> agentIdList = relations.stream().map(AgentReferralRelation::getAgentId).collect(Collectors.toList());
            ApiClientUserPageRequest pageRequest = new ApiClientUserPageRequest();
            pageRequest.setClientUserBizIdList(agentIdList);
            pageRequest.setApprovalStatus(request.getApprovalStatus());
            Result<IPage<ApiClientUserPageResponse>> result = apiClientUserFeignClient.page(pageRequest);
            if (!Objects.isNull(result.getData()) && !CollectionUtils.isEmpty(result.getData().getRecords())) {
                BeanUtils.copyProperties(result.getData(),iPage);
                iPage.setRecords(result.getData().getRecords().stream().map(dto -> {
                    ApiApprovalAccountPageResponse pageResponse = new ApiApprovalAccountPageResponse();
                    BeanUtils.copyProperties(dto,pageResponse);
                    return pageResponse;
                }).collect(Collectors.toList()));
            }
        }
        return Result.success(iPage);
    }

    /**
     * 推荐人审批账号
     * @param request
     * @return
     */
    @Override
    public Result approvalAccount(ApiApprovalAccountRequest request) {
        ApiClientUserEditApprovalStatusRequest statusRequest = new ApiClientUserEditApprovalStatusRequest();
        statusRequest.setClientUserBizId(request.getClientUserBizId());
        statusRequest.setRemark(request.getRemark());
        if (1 == request.getStatus()) {
            //同意 - 审批状态为待审核
            statusRequest.setApprovalStatus(CommonEnum.APPROVAL_STATUS_DSH.getCode());
        }else {
            //拒绝 - 审批状态为拒绝
            statusRequest.setApprovalStatus(CommonEnum.APPROVAL_STATUS_JJ.getCode());
        }
        apiClientUserFeignClient.editApprovalStatus(statusRequest);
        return Result.success();
    }

    /**
     * 当前登录客户端用户详情
     * @return
     */
    @Override
    public Result<ApiUserDetailResponse> detail() {
        ApiUserDetailResponse detailResponse = new ApiUserDetailResponse();
        //当前认证上下文的登录用户信息，查询最新的用户信息需要单独调接口去查询
        AuthUserDto authUserDto = SecurityUtil.getCurrentLoginUser();
        Result<ApiClientUserDetailResponse> result = apiClientUserFeignClient.detail(authUserDto.getClientUserBizId());
        ApiClientUserDetailResponse response = result.getData();
        if (!Objects.isNull(response)) {
            BeanUtils.copyProperties(response,detailResponse);
            detailResponse.setBankFileUrlList(response.getBankFileUrlList());
            detailResponse.setIdCardFileUrlList(response.getIdCardFileUrlList());
        }
        return Result.success(detailResponse);
    }

    /**
     * 保存推荐关系
     * @param agentIdList 被推荐人ID（客户端用户表唯一业务ID）列表
     * @param referrerId 推荐人ID（客户端用户表唯一业务ID）
     * @param referrerAccount 推荐人账号（客户端用户表手机号，如果是PC，这里就是sys_user的用户名）
     * @return
     */
    public Result saveAgentReferralRelation(List<String> agentIdList, String referrerId,
                                            String referrerAccount) {
        //CSF小程序项目 - 添加推荐关系
        ApiAgentReferralRelationSaveRequest request = new ApiAgentReferralRelationSaveRequest();
        //被推荐人ID（客户端用户表唯一业务ID）列表
        request.setAgentIdList(agentIdList);
        //租户业务ID
        request.setTenantBizId(TenantEnum.YD.getTenantBizId());
        //项目业务ID
        request.setProjectBizId(ProjectEnum.CSF_MINI_PROGRAM.getProjectBizId());
        //推荐人ID（客户端用户表唯一业务ID）
        request.setReferrerId(referrerId);
        //推荐人账号（客户端用户表手机号，如果是PC，这里就是sys_user的用户名）
        request.setReferrerAccount(referrerAccount);
        //推荐来源（PC、小程序等，字典，PC就是中台加入申请的）
        request.setSource(CommonEnum.SOURCE_TYPE_MINI_PROGRAM.getCode());
        apiAgentReferralRelationFeignClient.save(request);
        return Result.success();
    }

    /**
     * 根据手机号查询客户端用户信息
     * @param phone
     * @return
     */
    @Override
    public ApiClientUserPageResponse getApiClientUserPageResponse(String phone, String invitationCode) {
        ApiClientUserPageResponse response = null;
        //调用yd-user-api服务，查询客户端用户表信息，查询当前租户项目下是否有客户端手机号用户
        ApiClientUserPageRequest pageRequest = new ApiClientUserPageRequest();
        pageRequest.setPhone(phone);
        pageRequest.setInvitationCode(invitationCode);
        //暂时银盾租户 - 后期csf小程序多租户使用，小程序登录页应该有个下拉框去选择对应租户登录
        pageRequest.setTenantBizId(TenantEnum.YD.getTenantBizId());
        //CSF-小程序项目唯一业务ID（枚举固定）
        pageRequest.setProjectBizId(ProjectEnum.CSF_MINI_PROGRAM.getProjectBizId());
        Result<IPage<ApiClientUserPageResponse>> result = apiClientUserFeignClient.page(pageRequest);
        if (!Objects.isNull(result.getData()) && !CollectionUtils.isEmpty(result.getData().getRecords())) {
            List<ApiClientUserPageResponse> responses = result.getData().getRecords();
            response = responses.get(0);
        }
        return response;
    }

}
