package com.yd.csf.wx.api.service.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.bean.WxMaPhoneNumberInfo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yd.common.exception.BusinessException;
import com.yd.common.utils.HttpUtil;
import com.yd.csf.wx.api.dto.WxMaUserInfoDto;
import com.yd.csf.wx.api.service.ApiWechatAuthService;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * 微信小程序服务类
 */
@Service
@Slf4j
public class ApiWechatAuthServiceImpl implements ApiWechatAuthService {
    
    @Autowired
    private WxMaService wxMaService;
    
    @Value("${wx.miniapp.appid}")
    private String appid;

    /**
     * 获取微信会话信息
     * @param code
     * @return
     * @throws WxErrorException
     */
    @Override
    public WxMaJscode2SessionResult getSessionInfo(String code) {
        try {
            return wxMaService.getUserService().getSessionInfo(code);
        } catch (WxErrorException e) {
            e.printStackTrace();
            throw new BusinessException("获取微信会话信息异常");
        }
    }

    /**
     * 解密手机号
     * @param sessionKey
     * @param encryptedData
     * @param iv
     * @return
     */
    @Override
    public String decryptPhoneNumber(String sessionKey, String encryptedData, String iv) {
        try {
            WxMaPhoneNumberInfo phoneNumberInfo = wxMaService.getUserService()
                .getPhoneNoInfo(sessionKey, encryptedData, iv);
            return phoneNumberInfo.getPhoneNumber();
        } catch (Exception e) {
            log.error("手机号解密失败", e);
            throw new RuntimeException("手机号解密失败");
        }
    }

    /**
     * 通过openid获取微信用户信息
     * @param openid
     * @return
     */
    @Override
    public WxMaUserInfoDto getWxUserInfo(String openid) {
        try {
            String accessToken = wxMaService.getAccessToken();
            String url = String.format("https://api.weixin.qq.com/cgi-bin/user/info?access_token=%s&openid=%s&lang=zh_CN",
                    accessToken, openid);
            
            String response = HttpUtil.get(url);
            JSONObject jsonObject = JSON.parseObject(response);
            
            if (jsonObject.containsKey("errcode")) {
                log.warn("获取用户信息失败: {}", jsonObject.getString("errmsg"));
                return null;
            }
            
            WxMaUserInfoDto userInfo = new WxMaUserInfoDto();
            userInfo.setOpenId(openid);
            userInfo.setNickName(jsonObject.getString("nickname"));
            userInfo.setAvatarUrl(jsonObject.getString("headimgurl"));
            userInfo.setGender(jsonObject.getInteger("sex"));
            userInfo.setCountry(jsonObject.getString("country"));
            userInfo.setProvince(jsonObject.getString("province"));
            userInfo.setCity(jsonObject.getString("city"));
            
            return userInfo;
            
        } catch (Exception e) {
            log.warn("获取微信用户信息失败: {}", e.getMessage());
            return null;
        }
    }
}