package com.yd.csf.wx.feign.dto;

import lombok.Data;

/**
 * 封装token DTO
 */
@Data
public class TokenDto {

    /**
     * 访问令牌，用于访问受保护的资源
     */
    private String token;

    /**
     * 令牌类型，通常为 "Bearer"，表示持有者令牌
     */
    private String tokenType = "Bearer";

    /**
     * 令牌的有效期（以秒为单位），表示令牌在多少秒后过期
     */
    private long expiresIn;
}
