package com.yd.csf.wx.feign.client.login;

import com.yd.common.result.Result;
import com.yd.csf.wx.feign.fallback.login.ApiLoginFeignFallbackFactory;
import com.yd.csf.wx.feign.request.login.ApiPhoneCodeLoginRequest;
import com.yd.csf.wx.feign.response.login.ApiPhoneCodeLoginResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 香港保险小程序端服务-登录信息Feign客户端
 */
@FeignClient(name = "yd-csf-api",fallbackFactory = ApiLoginFeignFallbackFactory.class)
public interface ApiLoginFeignClient {

    /**
     * 手机验证码登录
     * @param request
     * @return
     */
    @PostMapping("/phone/code")
    Result<ApiPhoneCodeLoginResponse> phoneCodeLogin(@Validated @RequestBody ApiPhoneCodeLoginRequest request);

}
