package com.yd.csf.feign.dto.excel;

import com.yd.common.enums.CommonEnum;
import com.yd.common.enums.DictTypeEnum;
import com.yd.common.utils.ChineseTextConverter;
import com.yd.common.utils.DateUtil;
import com.yd.common.utils.RandomStringGenerator;
import com.yd.common.utils.StringUtil;
import com.yd.csf.feign.dto.appointment.*;
import com.yd.oss.feign.annotation.ExcelCollection;
import com.yd.oss.feign.annotation.ExcelField;
import com.yd.oss.feign.annotation.ExcelSheet;
import com.yd.user.feign.response.sysdict.GetDictItemListByDictTypeResponse;
import lombok.Data;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Data
@ExcelSheet(sheetIndex = 0)
public class ApiExcelImportAppointmentDto {

    //============以下是预约主信息-Excel导入字段============
    @ExcelField(name = "介紹人編號", titleRow = 2, titleCol = 0, valueRow = 2, valueCol = 1)
    private String mainReferrerId;

    @ExcelField(name = "预约日期", titleRow = 2, titleCol = 2, valueRow = 2, valueCol = 3)
    private String mainIntentionAppointmentDate;

    @ExcelField(name = "是否需体检", titleRow = 3, titleCol = 0, valueRow = 3, valueCol = 1)
    private String mainIsTj;

    @ExcelField(name = "預約時間", titleRow = 3, titleCol = 2, valueRow = 3, valueCol = 3)
    private String mainIntentionAppointmentTime;

    //============以下是客戶在港/澳停留時間信息-Excel导入字段============
    /**
     * 抵港(澳)日期及时间（到港时间）（预约信息主表）
     */
    @ExcelField(name = "抵港(澳)日期及时间", titleRow = 6, titleCol = 0, valueRow = 6, valueCol = 1)
    private String hkArrivalTime;

    /**
     * 离港(澳)日期及时间（离港时间）（预约信息主表）
     */
    @ExcelField(name = "离港(澳)日期及时间", titleRow = 6, titleCol = 2, valueRow = 6, valueCol = 3)
    private String hkDepartureTime;

    /**
     * 会面地点（字典）（会面地点）
     */
    @ExcelField(name = "会面地点", titleRow = 7, titleCol = 0, valueRow = 7, valueCol = 1)
    private String hkMeetingPoint;

    /**
     * 客户在港期间联络电话（预约信息主表）区号+号码
     */
    @ExcelField(name = "客户在港期间联络电话", titleRow = 7, titleCol = 2, valueRow = 7, valueCol = 3)
    private String hkHkMobile;

    /**
     * 随行人员姓名（陪同顾问姓名（FNA Form有填写，可带入））（预约信息主表）
     */
    @ExcelField(name = "随行人员姓名", titleRow = 8, titleCol = 0, valueRow = 8, valueCol = 1)
    private String hkAccompanyName;

    /**
     * 隨行人員聯絡電話（陪同顾问手机）（预约信息主表）区号+号码
     */
    @ExcelField(name = "隨行人員聯絡電話", titleRow = 8, titleCol = 2, valueRow = 8, valueCol = 3)
    private String hkAccompanyMobile;

    //============以下是预约资料及计划内容信息-Excel导入字段============
    /**
     * 保险公司名称（冗余字段）（产品计划信息表）
     */
    @ExcelField(name = "隨行人員聯絡電話", titleRow = 19, titleCol = 0, valueRow = 19, valueCol = 1)
    private String planCompanyName;

    /**
     * 基本計劃名稱（产品计划信息表，保险产品名称（中台保险产品名称，冗余））
     */
    @ExcelField(name = "基本計劃名稱", titleRow = 19, titleCol = 2, valueRow = 19, valueCol = 3)
    private String planProductName;

    /**
     * 保单币别（货币（字典））（产品计划信息表）
     */
    @ExcelField(name = "保单币别", titleRow = 22, titleCol = 0, valueRow = 22, valueCol = 1)
    private String planCurrency;

    /**
     * 付款频率（字典）（产品计划信息表）
     */
    @ExcelField(name = "付款频率", titleRow = 22, titleCol = 2, valueRow = 22, valueCol = 3)
    private String planPaymentFrequency;

    /**
     * 投保额（产品计划信息表）
     */
    @ExcelField(name = "投保额", titleRow = 23, titleCol = 0, valueRow = 23, valueCol = 1)
    private BigDecimal planSumInsured;

    /**
     * 供款年期（字典）（产品计划信息表）
     */
    @ExcelField(name = "投保额", titleRow = 23, titleCol = 2, valueRow = 23, valueCol = 3)
    private String planPaymentTerm;

    /**
     * 主險每期保费金额（每期保费）（产品计划信息表）
     */
    @ExcelField(name = "主險每期保费金额", titleRow = 24, titleCol = 0, valueRow = 24, valueCol = 1)
    private BigDecimal planEachIssuePremium;

    /**
     * 是否預繳保費 (如是，請填寫首期保費以外的剩餘保費)（是否预缴保费: 0-否, 1-是（字典）（产品计划信息表））
     */
    @ExcelField(name = "是否預繳保費", titleRow = 24, titleCol = 2, valueRow = 24, valueCol = 3)
    private String planIsPrepay;

    /**
     * 首期保费缴付方式
     * (銀聯/信用卡/銀行現金入數/現金/支票/電匯轉賬/銀行本票/銀行轉賬/銀行自動轉賬/其他)
     * （首期付款方式（字典） ）（产品计划信息表）
     */
    @ExcelField(name = "首期保费缴付方式", titleRow = 25, titleCol = 0, valueRow = 25, valueCol = 1)
    private String planInitialPaymentMethod;

    /**
     * 续期保费缴付方式
     * (銀聯/信用卡/銀行現金入數/現金/支票/電匯轉賬/銀行本票/銀行轉賬/銀行自動轉賬/其他)
     * （续期付款方式）（产品计划信息表）
     */
    @ExcelField(name = "续期保费缴付方式", titleRow = 25, titleCol = 1, valueRow = 25, valueCol = 2)
    private String planRenewalPaymentMethod;

    /**
     * 是否參加遞增保障權益/通脹加保權益
     * （是否参加递增保障权益: 0-否, 1-是（字典））（产品计划信息表）
     */
    @ExcelField(name = "是否參加遞增保障權益", titleRow = 26, titleCol = 0, valueRow = 26, valueCol = 1)
    private String planIsJoin;

    /**
     * 是否需提前保单生效日
     * （保单生效日）（产品计划信息表）
     */
    @ExcelField(name = "是否需提前保单生效日", titleRow = 26, titleCol = 2, valueRow = 26, valueCol = 3)
    private String planPolicyEffectiveDate;

    /**
     * 红利分配方式 (積存生息 / 現金支付 / 扣除保費 / 購買付清保險)
     * 红利分配方式（字典）（产品计划信息表）
     */
    @ExcelField(name = "红利分配方式", titleRow = 27, titleCol = 0, valueRow = 27, valueCol = 3)
    private String planDividendDistributionMethod;

    //============以下是保单持有人资料（投保人信息）-Excel导入字段============
    /**
     * 中文姓名（投保人信息表：名字）
     */
    @ExcelField(name = "中文姓名", titleRow = 30, titleCol = 0, valueRow = 30, valueCol = 1)
    private String policyholderName;

    /**
     * 英文姓名 (同护照)（投保人信息表：名字-英文）
     */
    @ExcelField(name = "英文姓名 (同护照)", titleRow = 30, titleCol = 2, valueRow = 30, valueCol = 3)
    private String policyholderNameEn;

    /**
     * 性别（投保人信息表：性别）
     */
    @ExcelField(name = "性别", titleRow = 31, titleCol = 0, valueRow = 31, valueCol = 1)
    private String policyholderGender;

    /**
     * 婚姻状况 (單身 / 已婚 / 離異/ 喪偶)（投保人信息表：婚姻状况（字典））
     */
    @ExcelField(name = "婚姻状况", titleRow = 31, titleCol = 2, valueRow = 31, valueCol = 3)
    private String policyholderMaritalStatus;

    /**
     * 出生日期 (西元 年/月/日)（投保人信息表：出生日期）
     */
    @ExcelField(name = "出生日期", titleRow = 32, titleCol = 0, valueRow = 32, valueCol = 1)
    private String policyholderBirthday;

    /**
     * 出生地 (省/市)（投保人信息表：出生地（省市））
     */
    @ExcelField(name = "出生地 (省/市)", titleRow = 32, titleCol = 2, valueRow = 32, valueCol = 3)
    private String policyholderBirthplace;

    /**
     * 國籍（投保人信息表：国籍）
     */
    @ExcelField(name = "國籍", titleRow = 33, titleCol = 0, valueRow = 33, valueCol = 1)
    private String policyholderNationality;

    /**
     * 身份证号码（投保人信息表：证件号码）
     */
    @ExcelField(name = "身份证号码", titleRow = 33, titleCol = 2, valueRow = 33, valueCol = 3)
    private String policyholderIdNumber;

    /**
     * 護照號碼（投保人信息表：护照号码）
     */
    @ExcelField(name = "護照號碼", titleRow = 34, titleCol = 0, valueRow = 34, valueCol = 1)
    private String policyholderPassportNo;

    /**
     * 港澳通行证号码（投保人信息表：通行证号码）
     */
    @ExcelField(name = "港澳通行证号码", titleRow = 34, titleCol = 2, valueRow = 34, valueCol = 3)
    private String policyholderPassNo;

    /**
     * 永久(住宅)地址（投保人信息表：居住地址）
     */
    @ExcelField(name = "永久(住宅)地址", titleRow = 35, titleCol = 0, valueRow = 35, valueCol = 1)
    private String policyholderResidentialAddress;

    /**
     * 通訊地址（投保人信息表：通讯地址）
     */
    @ExcelField(name = "通訊地址", titleRow = 36, titleCol = 0, valueRow = 36, valueCol = 1)
    private String policyholderMailingAddress;

    /**
     * 聯絡電話(手機)（投保人信息表：移动电话） 区号+号码
     */
    @ExcelField(name = "聯絡電話(手機)", titleRow = 37, titleCol = 0, valueRow = 37, valueCol = 1)
    private String policyholderMobile;

    /**
     * 聯絡電話(住宅) 区号+号码 TODO
     */
    @ExcelField(name = "聯絡電話(住宅)", titleRow = 37, titleCol = 2, valueRow = 37, valueCol = 3)
    private String policyholderResidenceMobile;

    /**
     * 电邮地址（投保人信息表：邮箱）
     */
    @ExcelField(name = "聯絡電話(住宅)", titleRow = 38, titleCol = 0, valueRow = 38, valueCol = 1)
    private String policyholderEmail;

    /**
     * 教育程度 (大學或以上/大專/中學/小學或以下)（投保人信息表：教育程度（字典））
     */
    @ExcelField(name = "教育程度", titleRow = 39, titleCol = 0, valueRow = 39, valueCol = 1)
    private String policyholderEducationLevel;

    /**
     * 公司名称（投保人信息表：公司名称）
     */
    @ExcelField(name = "公司名称", titleRow = 40, titleCol = 0, valueRow = 40, valueCol = 1)
    private String policyholderCompanyName;

    /**
     * 工作年期(僅限數字)（投保人信息表：总工作年期）
     */
    @ExcelField(name = "工作年期(僅限數字)", titleRow = 40, titleCol = 2, valueRow = 40, valueCol = 3)
    private BigDecimal policyholderTotalWorkingYears;

    /**
     * 职位及日常职务（投保人信息表：职位）
     */
    @ExcelField(name = "工作年期(僅限數字)", titleRow = 41, titleCol = 0, valueRow = 41, valueCol = 1)
    private String policyholderPosition;

    /**
     * 公司业务性质（投保人信息表：TODO）
     */
    @ExcelField(name = "公司业务性质", titleRow = 41, titleCol = 2, valueRow = 41, valueCol = 3)
    private String policyholderCompanyNature;

    /**
     * 公司地址（投保人信息表：公司地址）
     */
    @ExcelField(name = "公司地址", titleRow = 42, titleCol = 0, valueRow = 42, valueCol = 1)
    private String policyholderCompanyAddress;

    /**
     * 现时每月收入 (HKD)（投保人信息表：现时每月收入）
     */
    @ExcelField(name = "现时每月收入 (HKD)", titleRow = 43, titleCol = 0, valueRow = 43, valueCol = 1)
    private BigDecimal policyholderCurrentMonthlyIncome;

    //============以下是受保人资料 (如與保單持有人為同一人無須填寫)-Excel导入字段============
    /**
     * 與投保人關系（受保人信息表：与投保人关系（字典））
     */
    @ExcelField(name = "與投保人關系", titleRow = 46, titleCol = 0, valueRow = 46, valueCol = 1)
    private String insurantPolicyholderRel;

    /**
     * 中文姓名（受保人信息表：名字）
     */
    @ExcelField(name = "中文姓名", titleRow = 47, titleCol = 0, valueRow = 47, valueCol = 1)
    private String insurantName;

    /**
     * 英文姓名 (同护照)（受保人信息表：名字-英文）
     */
    @ExcelField(name = "英文姓名", titleRow = 47, titleCol = 2, valueRow = 47, valueCol = 3)
    private String insurantNameEn;

    /**
     * 性别（受保人信息表：性别）
     */
    @ExcelField(name = "性别", titleRow = 48, titleCol = 0, valueRow = 48, valueCol = 1)
    private String insurantGender;

    /**
     * 婚姻状况 (單身 / 已婚 / 離異/ 喪偶)（受保人信息表：婚姻状况（字典））
     */
    @ExcelField(name = "婚姻状况", titleRow = 48, titleCol = 2, valueRow = 48, valueCol = 3)
    private String insurantMaritalStatus;

    /**
     * 出生日期 (西元 年/月/日)（受保人信息表：出生日期）
     */
    @ExcelField(name = "出生日期", titleRow = 49, titleCol = 0, valueRow = 49, valueCol = 1)
    private String insurantBirthday;

    /**
     * 出生地 (省/市)（受保人信息表：出生地（省市））
     */
    @ExcelField(name = "出生地", titleRow = 49, titleCol = 2, valueRow = 49, valueCol = 3)
    private String insurantBirthplace;

    /**
     * 國籍（受保人信息表：国籍）
     */
    @ExcelField(name = "國籍", titleRow = 50, titleCol = 0, valueRow = 50, valueCol = 1)
    private String insurantNationality;

    /**
     * 身份证号码（受保人信息表：证件号码）
     */
    @ExcelField(name = "身份证号码", titleRow = 50, titleCol = 2, valueRow = 50, valueCol = 3)
    private String insurantIdNumber;

    /**
     * 護照號碼（受保人信息表：护照号码）
     */
    @ExcelField(name = "護照號碼", titleRow = 51, titleCol = 0, valueRow = 51, valueCol = 1)
    private String insurantPassportNo;

    /**
     * 港澳通行证号码（受保人信息表：通行证号码）
     */
    @ExcelField(name = "港澳通行证号码", titleRow = 51, titleCol = 2, valueRow = 51, valueCol = 3)
    private String insurantPassNo;

    /**
     * 永久(住宅)地址（受保人信息表：居住地址）
     */
    @ExcelField(name = "永久(住宅)地址", titleRow = 52, titleCol = 0, valueRow = 52, valueCol = 1)
    private String insurantResidentialAddress;

    /**
     * 通訊地址（受保人信息表：通讯地址）
     */
    @ExcelField(name = "通訊地址", titleRow = 53, titleCol = 0, valueRow = 53, valueCol = 1)
    private String insurantMailingAddress;

    /**
     * 聯絡電話(手機)（受保人信息表：移动电话） 区号+号码
     */
    @ExcelField(name = "聯絡電話(手機)", titleRow = 54, titleCol = 0, valueRow = 54, valueCol = 1)
    private String insurantMobile;

    /**
     * 聯絡電話(住宅) 区号+号码 TODO
     */
    @ExcelField(name = "聯絡電話(住宅)", titleRow = 54, titleCol = 2, valueRow = 54, valueCol = 3)
    private String insurantResidenceMobile;

    /**
     * 电邮地址（受保人信息表：邮箱）
     */
    @ExcelField(name = "电邮地址", titleRow = 55, titleCol = 0, valueRow = 55, valueCol = 1)
    private String insurantEmail;

    /**
     * 教育程度 (大學或以上/大專/中學/小學或以下)（受保人信息表：教育程度（字典））
     */
    @ExcelField(name = "教育程度", titleRow = 56, titleCol = 0, valueRow = 56, valueCol = 1)
    private String insurantEducationLevel;

    /**
     * 公司名称（受保人信息表：公司名称）
     */
    @ExcelField(name = "公司名称", titleRow = 57, titleCol = 0, valueRow = 57, valueCol = 1)
    private String insurantCompanyName;

    /**
     * 工作年期(僅限數字)（受保人信息表：总工作年期）
     */
    @ExcelField(name = "工作年期(僅限數字)", titleRow = 57, titleCol = 2, valueRow = 57, valueCol = 3)
    private BigDecimal insurantTotalWorkingYears;

    /**
     * 职位及日常职务（受保人信息表：职位）
     */
    @ExcelField(name = "职位及日常职务", titleRow = 58, titleCol = 0, valueRow = 58, valueCol = 1)
    private String insurantPosition;

    /**
     * 公司业务性质（受保人信息表：TODO）
     */
    @ExcelField(name = "公司业务性质", titleRow = 58, titleCol = 2, valueRow = 58, valueCol = 3)
    private String insurantPompanyNature;

    /**
     * 公司地址（受保人信息表：公司地址）
     */
    @ExcelField(name = "公司地址", titleRow = 59, titleCol = 0, valueRow = 59, valueCol = 1)
    private String insurantCompanyAddress;

    /**
     * 现时每月收入 (HKD)（受保人信息表：现时每月收入）
     */
    @ExcelField(name = "现时每月收入 (HKD)", titleRow = 60, titleCol = 0, valueRow = 60, valueCol = 1)
    private BigDecimal insurantCurrentMonthlyIncome;

    //============以下是第二持有人资料-Excel导入字段============
    /**
     * 中文姓名（第二持有人信息表：名字）
     */
    @ExcelField(name = "中文姓名", titleRow = 85, titleCol = 0, valueRow = 85, valueCol = 1)
    private String secondHolderName;

    /**
     * 英文姓名(同护照)（第二持有人信息表：名字-英文）
     */
    @ExcelField(name = "英文姓名(同护照)", titleRow = 85, titleCol = 2, valueRow = 85, valueCol = 3)
    private String secondHolderNameEn;

    /**
     * 出生日期（第二持有人信息表：出生日期）
     */
    @ExcelField(name = "出生日期", titleRow = 86, titleCol = 0, valueRow = 86, valueCol = 1)
    private String secondHolderBirthTime;

    /**
     * 身份证号码（第二持有人信息表：证件号码）
     */
    @ExcelField(name = "身份证号码", titleRow = 86, titleCol = 2, valueRow = 86, valueCol = 3)
    private String secondHolderIdNumber;

    /**
     * 性別（第二持有人信息表：性别）
     */
    @ExcelField(name = "性別", titleRow = 87, titleCol = 0, valueRow = 87, valueCol = 1)
    private String secondHolderGender;

    /**
     * 與受保人關係（第二持有人信息表：与受保人关系（字典））
     */
    @ExcelField(name = "與受保人關係", titleRow = 87, titleCol = 1, valueRow = 87, valueCol = 2)
    private String secondHolderInsurantRel;

//============以下是受益人列表信息============
    /**
     * 受益人列表信息
     * 每个受益人占用3行数据（64-66, 67-69, 70-72...）
     */
    @ExcelCollection(
            type = ApiExcelImportBeneficiaryDto.class,
            startRow = 64,
            rowSpan = 4,
            groupMode = ExcelCollection.GroupMode.FIXED_ROW_SPAN,
//            endFlagField = "beneficiaryName",
            nextFieldTitle = "第二持有人资料(只适用儿童单)"
    )
    private List<ApiExcelImportBeneficiaryDto> beneficiaryDtoList;

    /**
     * 附加计划列表信息
     * 单行模式，使用下一个对象的"保单币别"标题作为结束标志
     */
    @ExcelCollection(
            type = ApiExcelImportAdditionalDto.class,
            startRow = 20,
            rowSpan = 1,
            groupMode = ExcelCollection.GroupMode.FIXED_ROW_SPAN,
            endFlagField = "addProductName",
            nextFieldTitle = "保单币别"  // 新增：下一个对象的第一个字段标题
    )
    private List<ApiExcelImportAdditionalDto> additionalDtoList;

    /**
     * 构造预约主体信息
     * @param dto
     * @param infoDto
     * @return
     */
    public static ApiAppointmentInfoDto buildApiAppointmentInfoDto(ApiExcelImportAppointmentDto dto,
                                                                   ApiAppointmentInfoDto infoDto,
                                                                   List<GetDictItemListByDictTypeResponse> dictTypeResponses) {
        //到港时间
        infoDto.setArrivalTime(DateUtil.getLocalDateTime(dto.getHkArrivalTime()));
        //业务编号->介绍人编号 TODO
//        infoDto.setBusinessNo(dto.getMainReferrerId());
        //签单日->预约日期 (西元 年/月/日) + 預約時間
        infoDto.setSignDate(DateUtil.getLocalDateTime(dto.getMainIntentionAppointmentDate() + " " + dto.getMainIntentionAppointmentTime()));
        //离港时间->离港(澳)日期及时间（离港时间）（预约信息主表）
        infoDto.setDepartureTime(DateUtil.getLocalDateTime(dto.getHkDepartureTime()));
        //客户在港期间联络电话->客户在港期间联络电话（预约信息主表）区号+号码
        infoDto.setHkMobileCode(StringUtil.getSplitStr(dto.getHkHkMobile(),"-",0));
        infoDto.setHkMobile(StringUtil.getSplitStr(dto.getHkHkMobile(),"-",1));
        //是否体检
        infoDto.setIsTj(Integer.getInteger(GetDictItemListByDictTypeResponse.getItemValue(dictTypeResponses,
                DictTypeEnum.SYS_NO_YES.getItemValue(),dto.getMainIsTj())));
        //会面地点
        infoDto.setMeetingPoint(dto.getHkMeetingPoint());
        //转保声明选项 TODO
//        infoDto.setPolicyTransfer();
        return infoDto;
    }

    /**
     * 构造产品计划主信息
     * @param dto
     * @param infoDto
     * @return
     */
    public static ApiProductPlanMainInfoDto buildApiProductPlanMainInfoDto(ApiExcelImportAppointmentDto dto,
                                                                       ApiProductPlanMainInfoDto infoDto,
                                                                       List<GetDictItemListByDictTypeResponse> dictTypeResponses) {
        //保险公司名称
        infoDto.setCompanyName(dto.getPlanCompanyName());
        //货币（字典）
        infoDto.setPolicyCurrency(dto.getPlanCurrency());
        //预付额 TODO
//        infoDto.setDeductibles();
        //红利分配方式（字典）
        infoDto.setDividendDistributionMethod(GetDictItemListByDictTypeResponse.getItemValue(dictTypeResponses,
                DictTypeEnum.CSF_AP_DIVIDEND.getItemValue(),dto.getPlanDividendDistributionMethod()));
        //每期保费->主險每期保费金额（每期保费）（产品计划信息表）
        infoDto.setEachIssuePremium(dto.getPlanEachIssuePremium());
        //首期付款方式->首期保费缴付方式
        infoDto.setInitialPaymentMethod(GetDictItemListByDictTypeResponse.getItemValue(dictTypeResponses,
                DictTypeEnum.CSF_AP_FIRST_ISSUE.getItemValue(),dto.getPlanInitialPaymentMethod()));
        //是否参加递增保障权益->是否參加遞增保障權益/通脹加保權益
        infoDto.setIsJoin(Integer.parseInt(GetDictItemListByDictTypeResponse.getItemValue(dictTypeResponses,
                DictTypeEnum.SYS_NO_YES.getItemValue(),dto.getPlanIsJoin())));
        //是否预缴保费->是否預繳保費 (如是，請填寫首期保費以外的剩餘保費)（是否预缴保费: 0-否, 1-是（字典）（产品计划信息表））
        infoDto.setIsPrepay(Integer.parseInt(GetDictItemListByDictTypeResponse.getItemValue(dictTypeResponses,
                DictTypeEnum.SYS_NO_YES.getItemValue(),dto.getPlanIsPrepay())));
        //付款频率
        infoDto.setPaymentFrequency(dto.getPlanPaymentFrequency());
        //供款年期
        infoDto.setIssueNumber(dto.getPlanPaymentTerm());
        //保险产品名称->基本計劃名稱
        infoDto.setProductLaunchMainName(dto.getPlanProductName());
        //续期付款方式
        infoDto.setRenewalPaymentMethod(GetDictItemListByDictTypeResponse.getItemValue(dictTypeResponses,
                DictTypeEnum.CSF_AP_FIRST_ISSUE.getItemValue(),dto.getPlanRenewalPaymentMethod()));
        //保额
        infoDto.setSumInsured(dto.getPlanSumInsured());
        return infoDto;
    }

    /**
     * 构造投保人信息
     * @param dto
     * @param infoDto
     * @return
     */
    public static ApiPolicyholderInfoDto buildApiPolicyholderInfoDto(ApiExcelImportAppointmentDto dto,
                                                                     ApiPolicyholderInfoDto infoDto,
                                                                     List<GetDictItemListByDictTypeResponse> dictTypeResponses) {
        //出生日期->出生日期 (西元 年/月/日)（投保人信息表：出生日期）
        infoDto.setBirthday(DateUtil.getYMDLocalDateTime(dto.getPolicyholderBirthday()));
        //出生地
        infoDto.setBirthplace(dto.getPolicyholderBirthplace());
        //公司地址
        infoDto.setCompanyAddress(dto.getPolicyholderCompanyAddress());
        //现时每月收入->现时每月收入 (HKD)（投保人信息表：现时每月收入）
        infoDto.setCurrentMonthlyIncome(dto.getPolicyholderCurrentMonthlyIncome());
        //受雇于现职年期->工作年期(僅限數字)（投保人信息表：总工作年期）
        infoDto.setCurrentTenure(dto.getPolicyholderTotalWorkingYears());
        //教育程度（字典）-> 教育程度 (大學或以上/大專/中學/小學或以下)（投保人信息表：教育程度（字典））
        infoDto.setEducationLevel(GetDictItemListByDictTypeResponse.getItemValue(dictTypeResponses,
                DictTypeEnum.CSF_EDUCATION.getItemValue(),ChineseTextConverter.traditionalToSimplified(dto.getPolicyholderEducationLevel())));
        //邮箱
        infoDto.setEmail(dto.getPolicyholderEmail());
        //性别（字典）
        infoDto.setGender(GetDictItemListByDictTypeResponse.getItemValue(dictTypeResponses,
                DictTypeEnum.SYS_GENDER.getItemValue(),dto.getPolicyholderGender()));
        //证件号码->身份证号码
        infoDto.setIdNumber(dto.getPolicyholderIdNumber());
        //过往一年是否所属国家以外地区居住超过182日 TODO
//        infoDto.setIsExceed();
        //通讯地址
        infoDto.setMailingAddress(dto.getPolicyholderMailingAddress());
        //婚姻状况（字典）
        infoDto.setMaritalStatus(GetDictItemListByDictTypeResponse.getItemValue(dictTypeResponses,
                DictTypeEnum.CSF_MARRIAGE.getItemValue(),ChineseTextConverter.traditionalToSimplified(dto.getPolicyholderMaritalStatus())));
        infoDto.setMobile(StringUtil.getSplitStr(dto.getPolicyholderMobile(),"-",1));
        infoDto.setMobileCode(StringUtil.getSplitStr(dto.getPolicyholderMobile(),"-",0));
        //名字->中文姓名（投保人信息表：名字）
        infoDto.setNameCn(dto.getPolicyholderName());
        //名字-英文->英文姓名 (同护照)（投保人信息表：名字-英文）
        infoDto.setNamePyEn(dto.getPolicyholderNameEn());
        //国籍
        infoDto.setNationality(dto.getPolicyholderNationality());
        //通行证号码->港澳通行证号码（投保人信息表：通行证号码）
//        infoDto.setPassNo(dto.getPolicyholderPassNo());
//        infoDto.setPassportNo(dto.getPolicyholderPassportNo());
        //职位
        infoDto.setPosition(dto.getPolicyholderPosition());
        //居住地址->永久(住宅)地址（投保人信息表：居住地址）
        infoDto.setResidentialAddress(dto.getPolicyholderResidentialAddress());
        //总工作年期
        infoDto.setTotalWorkingYears(dto.getPolicyholderTotalWorkingYears());
        return infoDto;
    }

    /**
     * 构造受保人信息
     * @param dto
     * @param infoDto
     * @return
     */
    public static ApiInsurantInfoDto buildApiInsurantInfoDto(ApiExcelImportAppointmentDto dto,
                                                             ApiInsurantInfoDto infoDto,
                                                             List<GetDictItemListByDictTypeResponse> dictTypeResponses) {
        //出生日期->出生日期 (西元 年/月/日)（投保人信息表：出生日期）
        infoDto.setBirthday(DateUtil.getYMDLocalDateTime(dto.getInsurantBirthday()));
        //出生地
        infoDto.setBirthplace(dto.getInsurantBirthplace());
        //公司地址
        infoDto.setCompanyAddress(dto.getInsurantCompanyAddress());
        //现时每月收入->现时每月收入 (HKD)（投保人信息表：现时每月收入）
        infoDto.setCurrentMonthlyIncome(dto.getInsurantCurrentMonthlyIncome());
        //受雇于现职年期->工作年期(僅限數字)（投保人信息表：总工作年期）
        infoDto.setCurrentTenure(dto.getInsurantTotalWorkingYears());
        //教育程度（字典）-> 教育程度 (大學或以上/大專/中學/小學或以下)（投保人信息表：教育程度（字典））
        infoDto.setEducationLevel(GetDictItemListByDictTypeResponse.getItemValue(dictTypeResponses,
                DictTypeEnum.CSF_EDUCATION.getItemValue(),ChineseTextConverter.traditionalToSimplified(dto.getInsurantEducationLevel())));
        //邮箱
        infoDto.setEmail(dto.getInsurantEmail());
        //性别（字典）
        infoDto.setGender(GetDictItemListByDictTypeResponse.getItemValue(dictTypeResponses,
                DictTypeEnum.SYS_GENDER.getItemValue(),dto.getInsurantGender()));
        //证件号码->身份证号码
        infoDto.setIdNumber(dto.getInsurantIdNumber());
        //过往一年是否所属国家以外地区居住超过182日 TODO
//        infoDto.setIsExceed();
        //通讯地址
        infoDto.setMailingAddress(dto.getInsurantMailingAddress());
        //婚姻状况（字典）
        infoDto.setMaritalStatus(GetDictItemListByDictTypeResponse.getItemValue(dictTypeResponses,
                DictTypeEnum.CSF_MARRIAGE.getItemValue(),ChineseTextConverter.traditionalToSimplified(dto.getInsurantMaritalStatus())));
        infoDto.setMobile(StringUtil.getSplitStr(dto.getInsurantMobile(),"-",1));
        infoDto.setMobileCode(StringUtil.getSplitStr(dto.getInsurantMobile(),"-",0));
        //名字->中文姓名（投保人信息表：名字）
        infoDto.setNameCn(dto.getInsurantName());
        //名字-英文->英文姓名 (同护照)（投保人信息表：名字-英文）
        infoDto.setNamePyEn(dto.getInsurantNameEn());
        //国籍
        infoDto.setNationality(dto.getInsurantNationality());
        //通行证号码->港澳通行证号码（投保人信息表：通行证号码）
//        infoDto.setPassNo(dto.getInsurantPassNo());
//        infoDto.setPassportNo(dto.getInsurantPassportNo());
        //职位
        infoDto.setPosition(dto.getInsurantPosition());
        //居住地址->永久(住宅)地址（投保人信息表：居住地址）
        infoDto.setResidentialAddress(dto.getInsurantResidentialAddress());
        //总工作年期
        infoDto.setTotalWorkingYears(dto.getInsurantTotalWorkingYears());
        return infoDto;
    }

    /**
     * 构造第二持有人信息
     * @param dto
     * @param infoDto
     * @return
     */
    public static ApiSecondHolderInfoDto buildApiSecondHolderInfoDto(ApiExcelImportAppointmentDto dto,
                                                                     ApiSecondHolderInfoDto infoDto,
                                                                     List<GetDictItemListByDictTypeResponse> dictTypeResponses) {
        //出生日期
        infoDto.setBirthday(DateUtil.getYMDLocalDateTime(dto.getSecondHolderBirthTime()));
        //性别（字典）
        infoDto.setGender(GetDictItemListByDictTypeResponse.getItemValue(dictTypeResponses,
                DictTypeEnum.SYS_GENDER.getItemValue(),dto.getSecondHolderGender()));
        //身份证号码
        infoDto.setIdNumber(dto.getSecondHolderIdNumber());
        //与受保人关系（字典）
        infoDto.setInsurantRel(GetDictItemListByDictTypeResponse.getItemValue(dictTypeResponses,
                DictTypeEnum.CSF_AP_REL.getItemValue(),ChineseTextConverter.traditionalToSimplified(dto.getSecondHolderInsurantRel())));
        //名字
        infoDto.setNameCn(dto.getSecondHolderName());
        //名字-英文
        infoDto.setNamePyEn(dto.getSecondHolderNameEn());
        return infoDto;
    }

    /**
     * 构造受益人列表
     * @param dtoList
     * @param dictTypeResponses
     * @return
     */
    public static List<ApiBeneficiaryInfoDto> buildApiBeneficiaryInfoDtoList(List<ApiExcelImportBeneficiaryDto> dtoList,
                                                                             List<GetDictItemListByDictTypeResponse> dictTypeResponses,
                                                                             String appointmentBizId) {
        List<ApiBeneficiaryInfoDto> infoDtoList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(dtoList)) {
            infoDtoList = dtoList.stream().map(dto -> {
                ApiBeneficiaryInfoDto infoDto = new ApiBeneficiaryInfoDto();
                infoDto.setBeneficiaryBizId(RandomStringGenerator.generateBizId16(CommonEnum.UID_TYPE_BENEFICIARY.getCode()));
                infoDto.setAppointmentBizId(appointmentBizId);
                //受益比例
                infoDto.setBenefitRatio(dto.getBeneficiaryBenefitRatio());
                //出生日期
                infoDto.setBirthday(DateUtil.getYMDLocalDateTime(dto.getBeneficiaryBirthTime()));
                //中文姓名
                infoDto.setNameCn(dto.getBeneficiaryName());
                //名字-英文
                infoDto.setNamePyEn(dto.getBeneficiaryNameEn());
                //证件号码
                infoDto.setIdNumber(dto.getBeneficiaryIdNumber());
                //与受保人关系
                infoDto.setInsurantRel(GetDictItemListByDictTypeResponse.getItemValue(dictTypeResponses,
                        DictTypeEnum.CSF_AP_REL.getItemValue(),ChineseTextConverter.traditionalToSimplified(dto.getBeneficiaryInsurantRel())));
                return infoDto;
            }).collect(Collectors.toList());
        }
        return infoDtoList;
    }

    /**
     * 构造附加计划（附加险）列表
     * @param dtoList
     * @param dictTypeResponses
     * @param planBizId
     * @return
     */
    public static List<ApiProductPlanAdditionalInfoDto> buildApiProductPlanAdditionalInfoDto(List<ApiExcelImportAdditionalDto> dtoList,
                                                                                             List<GetDictItemListByDictTypeResponse> dictTypeResponses,
                                                                                             String planBizId) {
        List<ApiProductPlanAdditionalInfoDto> infoDtoList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(dtoList)) {
            infoDtoList = dtoList.stream().map(dto -> {
                ApiProductPlanAdditionalInfoDto infoDto = new ApiProductPlanAdditionalInfoDto();
                infoDto.setAdditionalBizId(RandomStringGenerator.generateBizId16(CommonEnum.UID_TYPE_ADDITIONAL.getCode()));
                infoDto.setPlanBizId(planBizId);
                //保险附加产品名称
                infoDto.setProductLaunchName(dto.getAddProductName());
                //保费
                infoDto.setEachIssuePremium(dto.getAddPremium());
                return infoDto;
            }).collect(Collectors.toList());
        }
        return infoDtoList;

    }
}
