package com.yd.csf.feign.fallback.team;

import com.yd.common.result.Result;
import com.yd.csf.feign.client.team.ApiTeamFeignClient;
import com.yd.csf.feign.request.team.ApiTeamListRequest;
import com.yd.csf.feign.request.team.ApiTeamPageRequest;
import com.yd.csf.feign.response.team.ApiTeamDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;
import java.util.List;

/**
 * 香港保险服务-团队信息Feign降级处理
 */
@Slf4j
@Component
public class ApiTeamFeignFallbackFactory implements FallbackFactory<ApiTeamFeignClient> {
    @Override
    public ApiTeamFeignClient create(Throwable cause) {
        return new ApiTeamFeignClient() {
            @Override
            public Result page(ApiTeamPageRequest request) {
                return null;
            }

            @Override
            public Result<List<ApiTeamDetailResponse>> list(ApiTeamListRequest request) {
                return null;
            }
        };
    }
}
