package com.yd.csf.feign.response.conditionconfig;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class ApiConditionConfigPageResponse {

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 条件配置表唯一业务ID
     */
    private String conditionBizId;

    /**
     * 条件类型表唯一业务ID
     */
    private String conditionTypeBizId;

    /**
     * 条件类型名称
     */
    private String conditionTypeName;

    /**
     * 条件编码
     */
    private String code;

    /**
     * 条件名称
     */
    private String name;

    /**
     * 最小值（在范围条件中表示最小值）
     */
    private BigDecimal minValue;

    /**
     * 最大值（在范围条件中表示最大值）
     */
    private BigDecimal maxValue;

    /**
     * 是否包含最小值（是否包含最小值，1表示包含，0表示不包含）
     */
    private Integer includeMin;

    /**
     * 是否包含最大值（是否包含最大值，1表示包含，0表示不包含）
     */
    private Integer includeMax;

    /**
     * 条件值（范围内的值）
     */
    private String conditionalValue;

    /**
     * 优先级（数字越小优先级越高）
     */
    private Integer priority;

    /**
     * 显示顺序
     */
    private Integer displayOrder;

    /**
     * 状态(0:停用 1:启用)
     */
    private Integer status;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

}
