package com.yd.csf.service.enums;

import org.apache.commons.lang3.ObjectUtils;

public enum PolicyStatusEnum {

    INFORCE("生效", "INFORCE"),
    LAPSED("保单失效", "LAPSED"),
    MATURED("退保", "MATURED"),
    COOLING_PERIOD_MATURED("冷静期退保", "COOLING_PERIOD_MATURED"),
    ;
    //字典项标签（名称）
    private String itemLabel;
    //字典项值
    private String itemValue;

    //构造函数
    PolicyStatusEnum(String itemLabel, String itemValue) {
        this.itemLabel = itemLabel;
        this.itemValue = itemValue;
    }

    /**
     * 根据 itemLabel 获取枚举
     *
     * @param itemLabel
     * @return
     */
    public static PolicyStatusEnum getEnumByItemLabel(String itemLabel) {
        if (ObjectUtils.isEmpty(itemLabel)) {
            return null;
        }
        for (PolicyStatusEnum anEnum : PolicyStatusEnum.values()) {
            if (anEnum.itemLabel.equals(itemLabel)) {
                return anEnum;
            }
        }
        return null;
    }

    public String getItemLabel() {
        return itemLabel;
    }

    public String getItemValue() {
        return itemValue;
    }

    /**
     * 根据 value 获取枚举
     *
     * @param value
     * @return
     */
    public static PolicyStatusEnum getEnumByValue(String value) {
        if (ObjectUtils.isEmpty(value)) {
            return null;
        }
        for (PolicyStatusEnum anEnum : PolicyStatusEnum.values()) {
            if (anEnum.getItemValue().equals(value)) {
                return anEnum;
            }
        }
        return null;
    }
}
