package com.yd.csf.api.service.impl;

import com.yd.common.enums.CommonEnum;
import com.yd.common.result.Result;
import com.yd.common.utils.RandomStringGenerator;
import com.yd.csf.api.service.ApiAppointmentReferrerLogService;
import com.yd.csf.feign.dto.appointment.ApiAppointmentReferrerDto;
import com.yd.csf.service.model.AppointmentReferrerLog;
import com.yd.csf.service.service.IAppointmentReferrerLogService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ApiAppointmentReferrerLogServiceImpl implements ApiAppointmentReferrerLogService {

    @Autowired
    private IAppointmentReferrerLogService iAppointmentReferrerLogService;

    /**
     * 保存预约-转介人信息日志信息
     * @param referrerDtoList
     * @param appointmentLogBizId
     * @return
     */
    @Override
    public Result saveAppointmentReferrerLogList(List<ApiAppointmentReferrerDto> referrerDtoList,
                                                 String appointmentLogBizId) {
        if (CollectionUtils.isEmpty(referrerDtoList)) {
            return Result.success();
        }
        List<AppointmentReferrerLog> saveList = referrerDtoList.stream().map(dto -> {
            AppointmentReferrerLog log = new AppointmentReferrerLog();
            BeanUtils.copyProperties(dto,log);
            log.setAppointmentLogBizId(appointmentLogBizId);
            log.setAppointmentReferrerLogBizId(RandomStringGenerator.generateBizId16(CommonEnum.UID_TYPE_APPOINTMENT_REFERRER_LOG.getCode()));
            return log;
        }).collect(Collectors.toList());

        iAppointmentReferrerLogService.saveOrUpdateBatch(saveList);
        return Result.success();
    }
}
