package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * SQL模板表 - 存储所有佣金计算相关的动态SQL模板，支持灵活配置和参数化查询，实现业务逻辑与代码解耦
 * </p>
 *
 * @author zxm
 * @since 2025-10-17
 */
@Getter
@Setter
@TableName("commission_sql_template")
public class CommissionSqlTemplate implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * SQL模板表唯一业务ID
     */
    @TableField("sql_template_biz_id")
    private String sqlTemplateBizId;

    /**
     * 模板编码
     */
    @TableField("sql_template_code")
    private String sqlTemplateCode;

    /**
     * 模板名称
     */
    @TableField("sql_template_name")
    private String sqlTemplateName;

    /**
     * 模板类型
     */
    @TableField("sql_template_type")
    private String sqlTemplateType;

    /**
     * 模板详细描述
     */
    @TableField("description")
    private String description;

    /**
     * SQL模板内容，支持参数化查询，使用 :参数名 作为占位符，如：SELECT SUM(fyc) FROM policy WHERE agent_id = :agentId AND period = :period
     */
    @TableField("sql_template")
    private String sqlTemplate;

    /**
     * 参数定义，JSON格式，定义SQL模板所需的参数列表，如：[{"name": "agentId", "type": "STRING", "required": true, "description": "业务员ID"}, {"name": "period", "type": "STRING", "required": true, "description": "计算周期"}]
     */
    @TableField("parameters")
    private String parameters;

    /**
     * 所属租户唯一业务ID
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 所属项目唯一业务ID
     */
    @TableField("project_biz_id")
    private String projectBizId;

    /**
     * 显示顺序
     */
    @TableField("display_order")
    private Integer displayOrder;

    /**
     * 状态：0-停用，1-启用。
     */
    @TableField("status")
    private Integer status;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Boolean isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
